/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands;

import org.apache.unomi.api.ProfileAlias;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.CDPProfileIDInput;
import org.apache.unomi.graphql.types.output.CDPProfileAlias;

public class RemoveAliasFromProfileCommand
extends BaseCommand<CDPProfileAlias> {
    private final String alias;
    private final CDPProfileIDInput profileIDInput;

    private RemoveAliasFromProfileCommand(Builder builder) {
        super(builder);
        this.alias = builder.alias;
        this.profileIDInput = builder.profileIDInput;
    }

    @Override
    public CDPProfileAlias execute() {
        ProfileService profileService = this.serviceManager.getService(ProfileService.class);
        ProfileAlias profileAlias = profileService.removeAliasFromProfile(this.profileIDInput.getId(), this.alias, this.profileIDInput.getClient().getId());
        return profileAlias != null ? new CDPProfileAlias(profileAlias) : null;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        private String alias;
        private CDPProfileIDInput profileIDInput;

        public Builder setAlias(String alias) {
            this.alias = alias;
            return this;
        }

        public Builder setProfileIDInput(CDPProfileIDInput profileIDInput) {
            this.profileIDInput = profileIDInput;
            return this;
        }

        public RemoveAliasFromProfileCommand build() {
            return new RemoveAliasFromProfileCommand(this);
        }
    }
}

