/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands.list;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.converters.UserListConverter;
import org.apache.unomi.graphql.types.input.CDPListInput;
import org.apache.unomi.graphql.types.output.CDPList;
import org.apache.unomi.lists.UserList;
import org.apache.unomi.services.UserListService;

public class CreateOrUpdateListCommand
extends BaseCommand<CDPList> {
    private final CDPListInput listInput;

    private CreateOrUpdateListCommand(Builder builder) {
        super(builder);
        this.listInput = builder.listInput;
    }

    @Override
    public CDPList execute() {
        String listId;
        UserListService userListService = this.serviceManager.getService(UserListService.class);
        UserList userList = userListService.load(listId = StringUtils.isEmpty((CharSequence)this.listInput.getId()) ? this.listInput.getName() : this.listInput.getId());
        if (userList == null) {
            Metadata metadata = new Metadata();
            metadata.setId(listId);
            userList = new UserList();
            userList.setItemType("userList");
            userList.setMetadata(metadata);
        }
        userList.setScope(this.listInput.getView());
        userList.getMetadata().setName(this.listInput.getName());
        userList.getMetadata().setScope(this.listInput.getView());
        userListService.save(userList);
        return new CDPList(UserListConverter.convertToUnomiList(userList));
    }

    public static Builder create(CDPListInput listInput) {
        return new Builder(listInput);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        private final CDPListInput listInput;

        public Builder(CDPListInput listInput) {
            this.listInput = listInput;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.listInput, "The list argument can not be null");
            Objects.requireNonNull(this.listInput.getName(), "The \"name\" field can not be null");
            Objects.requireNonNull(this.listInput.getView(), "The \"view\" field can not be null");
        }

        public CreateOrUpdateListCommand build() {
            this.validate();
            return new CreateOrUpdateListCommand(this);
        }
    }
}

