/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands.list;

import java.util.Objects;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.services.UserListService;

public class DeleteListCommand
extends BaseCommand<Boolean> {
    private final String listId;

    private DeleteListCommand(Builder builder) {
        super(builder);
        this.listId = builder.listId;
    }

    @Override
    public Boolean execute() {
        UserListService userListService = this.serviceManager.getService(UserListService.class);
        if (userListService.load(this.listId) == null) {
            return false;
        }
        userListService.delete(this.listId);
        return userListService.load(this.listId) == null;
    }

    public static Builder create(String listId) {
        return new Builder(listId);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        private final String listId;

        public Builder(String listId) {
            this.listId = listId;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.listId, "The listID argument can not be null");
        }

        public DeleteListCommand build() {
            this.validate();
            return new DeleteListCommand(this);
        }
    }
}

