/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands.list;

import java.util.Collections;
import java.util.Objects;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.CDPProfileIDInput;
import org.apache.unomi.graphql.utils.EventBuilder;
import org.apache.unomi.lists.UserList;
import org.apache.unomi.services.UserListService;

public class RemoveProfileFromListCommand
extends BaseCommand<Boolean> {
    private final String listId;
    private final CDPProfileIDInput profileIDInput;

    private RemoveProfileFromListCommand(Builder builder) {
        super(builder);
        this.listId = builder.listId;
        this.profileIDInput = builder.profileIDInput;
    }

    @Override
    public Boolean execute() {
        UserList userList = this.serviceManager.getService(UserListService.class).load(this.listId);
        if (userList == null) {
            return null;
        }
        ProfileService profileService = this.serviceManager.getService(ProfileService.class);
        Profile profile = profileService.load(this.profileIDInput.getId());
        if (profile == null) {
            return null;
        }
        Event event = EventBuilder.create("cdp_listsUpdateEvent", profile).setProperty("leaveLists", Collections.singletonList(this.listId)).setPersistent(true).build();
        int eventCode = this.serviceManager.getService(EventService.class).send(event);
        if (eventCode == 4) {
            profileService.save(event.getProfile());
            return true;
        }
        return false;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        private String listId;
        private CDPProfileIDInput profileIDInput;

        public Builder listId(String listId) {
            this.listId = listId;
            return this;
        }

        public Builder profileIDInput(CDPProfileIDInput profileIDInput) {
            this.profileIDInput = profileIDInput;
            return this;
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(this.listId, "The \"listID\" argument can not be null");
            Objects.requireNonNull(this.profileIDInput, "The \"profileID\" argument can not be null");
        }

        public RemoveProfileFromListCommand build() {
            this.validate();
            return new RemoveProfileFromListCommand(this);
        }
    }
}

