/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands.segments;

import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.graphql.commands.BaseCommand;
import org.apache.unomi.graphql.types.input.BaseSegmentInput;

public abstract class BaseCreateOrUpdateSegmentCommand<INPUT extends BaseSegmentInput, OUTPUT>
extends BaseCommand<OUTPUT> {
    private final INPUT segmentInput;

    public BaseCreateOrUpdateSegmentCommand(Builder builder) {
        super(builder);
        this.segmentInput = builder.segmentInput;
    }

    protected Segment preparedSegmentWithoutCondition(INPUT segmentInput) {
        String segmentId;
        SegmentService segmentService = this.serviceManager.getService(SegmentService.class);
        Segment segment = segmentService.getSegmentDefinition(segmentId = StringUtils.isEmpty((CharSequence)segmentInput.getId()) ? segmentInput.getName() : segmentInput.getId());
        if (segment == null) {
            segment = new Segment();
            segment.setItemType("segment");
            segment.setMetadata(this.createMedata(segmentId));
        } else {
            if (segment.getMetadata() == null) {
                segment.setMetadata(new Metadata());
            }
            segment.setItemId(segmentId);
            segment.getMetadata().setId(segmentId);
            segment.getMetadata().setName(segmentInput.getName());
            segment.getMetadata().setScope(segmentInput.getView());
        }
        return segment;
    }

    private Metadata createMedata(String segmentId) {
        Metadata metadata = new Metadata();
        metadata.setId(segmentId);
        metadata.setName(this.segmentInput.getName());
        metadata.setScope(this.segmentInput.getView());
        return metadata;
    }

    public static class Builder<INPUT extends BaseSegmentInput, B extends BaseCommand.Builder>
    extends BaseCommand.Builder<B> {
        private final INPUT segmentInput;

        public Builder(INPUT segmentInput) {
            this.segmentInput = segmentInput;
        }

        public INPUT getSegmentInput() {
            return this.segmentInput;
        }

        @Override
        public void validate() {
            super.validate();
            if (this.segmentInput == null) {
                throw new IllegalArgumentException();
            }
            if (StringUtils.isEmpty((CharSequence)this.segmentInput.getName())) {
                throw new IllegalArgumentException();
            }
            if (StringUtils.isEmpty((CharSequence)this.segmentInput.getView())) {
                throw new IllegalArgumentException();
            }
        }
    }
}

