/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands.segments;

import java.util.Map;
import java.util.Objects;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.graphql.commands.segments.BaseCreateOrUpdateSegmentCommand;
import org.apache.unomi.graphql.condition.factories.ProfileConditionFactory;
import org.apache.unomi.graphql.types.input.CDPSegmentInput;
import org.apache.unomi.graphql.types.output.CDPSegment;

public class CreateOrUpdateSegmentCommand
extends BaseCreateOrUpdateSegmentCommand<CDPSegmentInput, CDPSegment> {
    private final CDPSegmentInput segmentInput;

    private CreateOrUpdateSegmentCommand(Builder builder) {
        super(builder);
        this.segmentInput = (CDPSegmentInput)builder.getSegmentInput();
    }

    @Override
    public CDPSegment execute() {
        Segment segment = this.preparedSegmentWithoutCondition(this.segmentInput);
        Map profileFilterAsMap = null;
        Map segmentArgumentAsMap = (Map)this.environment.getArgument("segment");
        if (segmentArgumentAsMap != null) {
            profileFilterAsMap = (Map)segmentArgumentAsMap.get("profiles");
        }
        Condition condition = ProfileConditionFactory.get(this.environment).profileFilterInputCondition(this.segmentInput.getProfiles(), profileFilterAsMap);
        segment.setCondition(condition);
        this.serviceManager.getService(SegmentService.class).setSegmentDefinition(segment);
        return new CDPSegment(segment);
    }

    public static Builder create(CDPSegmentInput segmentInput) {
        return new Builder(segmentInput);
    }

    public static class Builder
    extends BaseCreateOrUpdateSegmentCommand.Builder<CDPSegmentInput, Builder> {
        public Builder(CDPSegmentInput segmentInput) {
            super(segmentInput);
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(((CDPSegmentInput)this.getSegmentInput()).getProfiles(), "The profiles field can not be null");
        }

        public CreateOrUpdateSegmentCommand build() {
            this.validate();
            return new CreateOrUpdateSegmentCommand(this);
        }
    }
}

