/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands.segments;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.graphql.commands.segments.BaseCreateOrUpdateSegmentCommand;
import org.apache.unomi.graphql.types.input.UnomiSegmentInput;
import org.apache.unomi.graphql.types.output.UnomiSegment;
import org.apache.unomi.graphql.utils.GraphQLObjectMapper;

public class CreateOrUpdateUnomiSegmentCommand
extends BaseCreateOrUpdateSegmentCommand<UnomiSegmentInput, UnomiSegment> {
    private final UnomiSegmentInput segmentInput;

    public CreateOrUpdateUnomiSegmentCommand(Builder builder) {
        super(builder);
        this.segmentInput = (UnomiSegmentInput)builder.getSegmentInput();
    }

    @Override
    public UnomiSegment execute() {
        SegmentService segmentService = this.serviceManager.getService(SegmentService.class);
        Segment segment = this.preparedSegmentWithoutCondition(this.segmentInput);
        Condition condition = (Condition)GraphQLObjectMapper.getInstance().convertValue(this.segmentInput.getCondition(), Condition.class);
        this.decorateCondition(condition);
        segment.setCondition(condition);
        segmentService.setSegmentDefinition(segment);
        return new UnomiSegment(segment);
    }

    private Condition decorateCondition(Condition condition) {
        condition.setConditionType(this.serviceManager.getService(DefinitionsService.class).getConditionType(condition.getConditionTypeId()));
        if (condition.containsParameter("subConditions")) {
            List subConditions = (List)condition.getParameter("subConditions");
            List subConditionDecorators = subConditions.stream().map(subConditionAsMap -> {
                Condition subCondition = (Condition)GraphQLObjectMapper.getInstance().convertValue(subConditionAsMap, Condition.class);
                return this.decorateCondition(subCondition);
            }).collect(Collectors.toList());
            condition.setParameter("subConditions", subConditionDecorators);
        }
        return condition;
    }

    public static Builder create(UnomiSegmentInput segmentInput) {
        return new Builder(segmentInput);
    }

    public static class Builder
    extends BaseCreateOrUpdateSegmentCommand.Builder<UnomiSegmentInput, Builder> {
        public Builder(UnomiSegmentInput segmentInput) {
            super(segmentInput);
        }

        @Override
        public void validate() {
            super.validate();
            Objects.requireNonNull(((UnomiSegmentInput)this.getSegmentInput()).getCondition(), "The condition field can not be null");
        }

        public CreateOrUpdateUnomiSegmentCommand build() {
            this.validate();
            return new CreateOrUpdateUnomiSegmentCommand(this);
        }
    }
}

