/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.commands.segments;

import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.segments.DependentMetadata;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.graphql.commands.BaseCommand;

public class DeleteSegmentCommand
extends BaseCommand<Boolean> {
    private final String segmentId;

    private DeleteSegmentCommand(Builder builder) {
        super(builder);
        this.segmentId = builder.segmentId;
    }

    @Override
    public Boolean execute() {
        DependentMetadata dependentMetadata = this.serviceManager.getService(SegmentService.class).removeSegmentDefinition(this.segmentId, true);
        return dependentMetadata.getScorings().isEmpty() && dependentMetadata.getSegments().isEmpty();
    }

    public static Builder create(String segmentId) {
        return new Builder(segmentId);
    }

    public static class Builder
    extends BaseCommand.Builder<Builder> {
        private final String segmentId;

        public Builder(String segmentId) {
            this.segmentId = segmentId;
        }

        @Override
        public void validate() {
            super.validate();
            if (StringUtils.isEmpty((CharSequence)this.segmentId)) {
                throw new IllegalArgumentException("The \"segmentID\" variable can not be null or empty");
            }
        }

        public DeleteSegmentCommand build() {
            this.validate();
            return new DeleteSegmentCommand(this);
        }
    }
}

