/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.factories;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.conditions.ConditionType;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.utils.ConditionBuilder;

public class ConditionFactory {
    protected DataFetchingEnvironment environment;
    protected DefinitionsService definitionsService;
    protected String conditionTypeId;
    private Map<String, ConditionType> conditionTypesMap;

    public ConditionFactory(String conditionTypeId, DataFetchingEnvironment environment) {
        this.environment = environment;
        this.conditionTypeId = conditionTypeId;
        ServiceManager context = (ServiceManager)environment.getContext();
        this.definitionsService = context.getService(DefinitionsService.class);
        this.conditionTypesMap = this.definitionsService.getAllConditionTypes().stream().collect(Collectors.toMap(Item::getItemId, Function.identity()));
    }

    public Condition matchAllCondition() {
        return ConditionBuilder.create(this.getConditionType("matchAllCondition")).build();
    }

    public Condition booleanCondition(String operator, List<Condition> subConditions) {
        return ConditionBuilder.create(this.getConditionType("booleanCondition")).parameter("operator", operator).parameter("subConditions", subConditions).build();
    }

    public Condition propertyCondition(String propertyName, String operator, String propertyValueName, Object propertyValue) {
        return ConditionBuilder.create(this.getConditionType(this.conditionTypeId)).property(propertyName).operator(operator).parameter(propertyValueName, propertyValue).build();
    }

    public Condition propertyCondition(String propertyName, Object propertyValue) {
        return this.propertyCondition(propertyName, "equals", propertyValue);
    }

    public Condition propertyCondition(String propertyName, String operator, Object propertyValue) {
        return this.propertyCondition(propertyName, operator, "propertyValue", propertyValue);
    }

    public Condition integerPropertyCondition(String propertyName, Object propertyValue) {
        return this.integerPropertyCondition(propertyName, "equals", propertyValue);
    }

    public Condition integerPropertyCondition(String propertyName, String operator, Object propertyValue) {
        return this.propertyCondition(propertyName, operator, "propertyValueInteger", propertyValue);
    }

    public Condition datePropertyCondition(String propertyName, String operator, Object propertyValue) {
        return this.propertyCondition(propertyName, operator, "propertyValueDate", propertyValue);
    }

    public Condition propertiesCondition(String propertyName, String operator, List<String> propertyValues) {
        return this.propertyCondition(propertyName, operator, "propertyValues", propertyValues);
    }

    public ConditionType getConditionType(String typeId) {
        return this.conditionTypesMap.get(typeId);
    }

    public <INPUT> Condition filtersToCondition(List<INPUT> inputFilters, Function<INPUT, Condition> function, String operator) {
        List<Condition> subConditions = inputFilters.stream().map(function).collect(Collectors.toList());
        return this.booleanCondition(operator, subConditions);
    }

    public <INPUT> Condition filtersToCondition(List<INPUT> inputFilters, List<Map<String, Object>> filterInputAsMap, BiFunction<INPUT, Map<String, Object>, Condition> function, String operator) {
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        for (int i = 0; i < inputFilters.size(); ++i) {
            subConditions.add(function.apply(inputFilters.get(i), filterInputAsMap.get(i)));
        }
        return this.booleanCondition(operator, subConditions);
    }
}

