/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.factories;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.graphql.condition.factories.ConditionFactory;
import org.apache.unomi.graphql.schema.ComparisonConditionTranslator;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;
import org.apache.unomi.graphql.schema.PropertyValueTypeHelper;
import org.apache.unomi.graphql.types.input.CDPConsentUpdateEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPListsUpdateEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPSessionEventFilterInput;
import org.apache.unomi.graphql.utils.ReflectionUtil;

public class EventConditionFactory
extends ConditionFactory {
    private static EventConditionFactory instance;

    public static synchronized EventConditionFactory get(DataFetchingEnvironment environment) {
        if (instance == null) {
            instance = new EventConditionFactory(environment);
        }
        return instance;
    }

    private EventConditionFactory(DataFetchingEnvironment environment) {
        super("eventPropertyCondition", environment);
    }

    public Condition eventFilterInputCondition(CDPEventFilterInput filterInput, Map<String, Object> filterInputAsMap) {
        List listFilterInputAsMap;
        if (filterInput == null) {
            return this.matchAllCondition();
        }
        ArrayList<Condition> rootSubConditions = new ArrayList<Condition>();
        if (filterInput.getCdp_timestamp_equals() != null) {
            rootSubConditions.add(this.datePropertyCondition("timeStamp", "equals", filterInput.getCdp_timestamp_equals()));
        }
        if (filterInput.getCdp_timestamp_gt() != null) {
            rootSubConditions.add(this.datePropertyCondition("timeStamp", "greaterThan", filterInput.getCdp_timestamp_gt()));
        }
        if (filterInput.getCdp_timestamp_gte() != null) {
            rootSubConditions.add(this.datePropertyCondition("timeStamp", "greaterThanOrEqualTo", filterInput.getCdp_timestamp_gte()));
        }
        if (filterInput.getCdp_timestamp_lt() != null) {
            rootSubConditions.add(this.datePropertyCondition("timeStamp", "lessThan", filterInput.getCdp_timestamp_lt()));
        }
        if (filterInput.getCdp_timestamp_lte() != null) {
            rootSubConditions.add(this.datePropertyCondition("timeStamp", "lessThanOrEqualTo", filterInput.getCdp_timestamp_lte()));
        }
        if (filterInput.getId_equals() != null) {
            rootSubConditions.add(this.propertyCondition("itemId", filterInput.getId_equals()));
        }
        if (filterInput.getCdp_clientID_equals() != null) {
            rootSubConditions.add(this.propertyCondition("properties.clientId", filterInput.getCdp_clientID_equals()));
        }
        if (filterInput.getCdp_profileID_equals() != null) {
            rootSubConditions.add(this.propertyCondition("profileId", filterInput.getCdp_profileID_equals()));
        }
        if (filterInput.getCdp_sourceID_equals() != null) {
            rootSubConditions.add(this.propertyCondition("source.itemId", filterInput.getCdp_sourceID_equals()));
        }
        if (filterInput.getCdp_listsUpdateEvent() != null) {
            rootSubConditions.add(this.listUpdateEventCondition(filterInput.getCdp_listsUpdateEvent()));
        }
        if (filterInput.getCdp_consentUpdateEvent() != null) {
            rootSubConditions.add(this.createCdpConsentUpdateEventCondition(filterInput.getCdp_consentUpdateEvent()));
        }
        if (filterInput.getCdp_sessionEvent() != null) {
            rootSubConditions.add(this.createCdpSessionEventCondition(filterInput.getCdp_sessionEvent()));
        }
        if (filterInput.getCdp_profileUpdateEvent() != null) {
            Map profileUpdateEventAsMap = (Map)filterInputAsMap.get("cdp_profileUpdateEvent");
            rootSubConditions.add(this.createDynamicEventCondition("cdp_profileUpdateEvent", profileUpdateEventAsMap, "CDP_ProfileUpdateEventFilterInput"));
        }
        List<String> nonDynamicFields = ReflectionUtil.getNonDynamicFields(filterInput.getClass());
        GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)this.environment.getGraphQLSchema().getType(ReflectionUtil.resolveTypeName(CDPEventFilterInput.class));
        List<String> dynamicInputFields = inputObjectType.getFieldDefinitions().stream().filter(inputObjectField -> !nonDynamicFields.contains(inputObjectField.getName())).map(GraphQLInputObjectField::getName).collect(Collectors.toList());
        dynamicInputFields.forEach(fieldName -> {
            Map dynamicEventAsMap = (Map)filterInputAsMap.get(fieldName);
            if (dynamicEventAsMap != null) {
                String typeName = ((GraphQLInputObjectType)inputObjectType.getFieldDefinition(fieldName).getType()).getName();
                rootSubConditions.add(this.createDynamicEventCondition((String)fieldName, dynamicEventAsMap, typeName));
            }
        });
        if (filterInput.getAnd() != null && !filterInput.getAnd().isEmpty()) {
            listFilterInputAsMap = (List)filterInputAsMap.get("and");
            rootSubConditions.add(this.filtersToCondition(filterInput.getAnd(), listFilterInputAsMap, this::eventFilterInputCondition, "and"));
        }
        if (filterInput.getOr() != null && !filterInput.getOr().isEmpty()) {
            listFilterInputAsMap = (List)filterInputAsMap.get("or");
            rootSubConditions.add(this.filtersToCondition(filterInput.getOr(), listFilterInputAsMap, this::eventFilterInputCondition, "or"));
        }
        return this.booleanCondition("and", rootSubConditions);
    }

    private Condition createDynamicEventCondition(String dynamicPropertyName, Map<String, Object> eventAsMap, String inputTypeName) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        conditions.add(this.propertyCondition("eventType", dynamicPropertyName));
        eventAsMap.forEach((propertyName, propertyValue) -> {
            String[] propertyFilter = PropertyNameTranslator.translateFromGraphQLToUnomi(propertyName).split("_", -1);
            String propertyValueType = PropertyValueTypeHelper.getPropertyValueParameterForInputType(inputTypeName, propertyName, this.environment);
            conditions.add(this.propertyCondition("properties." + propertyFilter[0], ComparisonConditionTranslator.translateFromGraphQLToUnomi(propertyFilter[1]), propertyValueType, propertyValue));
        });
        return this.booleanCondition("and", conditions);
    }

    private Condition listUpdateEventCondition(CDPListsUpdateEventFilterInput cdp_listsUpdateEvent) {
        ArrayList<Condition> rootSubConditions = new ArrayList<Condition>();
        if (cdp_listsUpdateEvent.getJoinLists_contains() != null && !cdp_listsUpdateEvent.getJoinLists_contains().isEmpty()) {
            rootSubConditions.add(this.propertiesCondition("properties.joinLists", "inContains", cdp_listsUpdateEvent.getJoinLists_contains()));
        }
        if (cdp_listsUpdateEvent.getLeaveLists_contains() != null && !cdp_listsUpdateEvent.getLeaveLists_contains().isEmpty()) {
            rootSubConditions.add(this.propertiesCondition("properties.leaveLists", "inContains", cdp_listsUpdateEvent.getLeaveLists_contains()));
        }
        return this.booleanCondition("and", rootSubConditions);
    }

    private Condition createCdpConsentUpdateEventCondition(CDPConsentUpdateEventFilterInput eventFilterInput) {
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        if (eventFilterInput.getType_equals() != null) {
            subConditions.add(this.propertyCondition("properties.type", eventFilterInput.getType_equals()));
        }
        if (eventFilterInput.getStatus_equals() != null) {
            subConditions.add(this.propertyCondition("properties.status", eventFilterInput.getStatus_equals()));
        }
        if (eventFilterInput.getLastUpdate_equals() != null) {
            subConditions.add(this.datePropertyCondition("properties.lastUpdate", "equals", eventFilterInput.getLastUpdate_equals()));
        }
        if (eventFilterInput.getLastUpdate_lt() != null) {
            subConditions.add(this.datePropertyCondition("properties.lastUpdate", "lessThan", eventFilterInput.getLastUpdate_lt()));
        }
        if (eventFilterInput.getLastUpdate_lte() != null) {
            subConditions.add(this.datePropertyCondition("properties.lastUpdate", "lessThanOrEqualTo", eventFilterInput.getLastUpdate_lte()));
        }
        if (eventFilterInput.getLastUpdate_gt() != null) {
            subConditions.add(this.datePropertyCondition("properties.lastUpdate", "greaterThan", eventFilterInput.getLastUpdate_gt()));
        }
        if (eventFilterInput.getLastUpdate_gte() != null) {
            subConditions.add(this.datePropertyCondition("properties.lastUpdate", "greaterThanOrEqualTo", eventFilterInput.getLastUpdate_gte()));
        }
        if (eventFilterInput.getExpiration_equals() != null) {
            subConditions.add(this.datePropertyCondition("properties.expiration", "equals", eventFilterInput.getExpiration_equals()));
        }
        if (eventFilterInput.getExpiration_lt() != null) {
            subConditions.add(this.datePropertyCondition("properties.expiration", "lessThan", eventFilterInput.getExpiration_lt()));
        }
        if (eventFilterInput.getExpiration_lte() != null) {
            subConditions.add(this.datePropertyCondition("properties.expiration", "lessThanOrEqualTo", eventFilterInput.getExpiration_lte()));
        }
        if (eventFilterInput.getExpiration_gt() != null) {
            subConditions.add(this.datePropertyCondition("properties.expiration", "greaterThan", eventFilterInput.getExpiration_gt()));
        }
        if (eventFilterInput.getExpiration_gte() != null) {
            subConditions.add(this.datePropertyCondition("properties.expiration", "greaterThanOrEqualTo", eventFilterInput.getExpiration_gte()));
        }
        return this.booleanCondition("and", subConditions);
    }

    private Condition createCdpSessionEventCondition(CDPSessionEventFilterInput eventFilterInput) {
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        if (eventFilterInput.getState_equals() != null) {
            subConditions.add(this.propertyCondition("properties.state", eventFilterInput.getState_equals().name()));
        }
        if (eventFilterInput.getUnomi_scope_equals() != null) {
            subConditions.add(this.propertyCondition("properties.scope", eventFilterInput.getUnomi_scope_equals()));
        }
        if (eventFilterInput.getUnomi_sessionId_equals() != null) {
            subConditions.add(this.propertyCondition("properties.sessionId", eventFilterInput.getUnomi_sessionId_equals()));
        }
        return this.booleanCondition("and", subConditions);
    }
}

