/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.factories;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.unomi.api.GeoPoint;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.condition.factories.ConditionFactory;
import org.apache.unomi.graphql.condition.factories.EventConditionFactory;
import org.apache.unomi.graphql.schema.ComparisonConditionTranslator;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;
import org.apache.unomi.graphql.schema.PropertyValueTypeHelper;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPInterestFilterInput;
import org.apache.unomi.graphql.types.input.CDPProfileEventsFilterInput;
import org.apache.unomi.graphql.types.input.CDPProfileFilterInput;
import org.apache.unomi.graphql.types.input.CDPProfilePropertiesFilterInput;
import org.apache.unomi.graphql.types.input.CDPSegmentFilterInput;
import org.apache.unomi.graphql.utils.ConditionBuilder;
import org.apache.unomi.graphql.utils.StringUtils;

public class ProfileConditionFactory
extends ConditionFactory {
    private static ProfileConditionFactory instance;

    public static synchronized ProfileConditionFactory get(DataFetchingEnvironment environment) {
        if (instance == null) {
            instance = new ProfileConditionFactory(environment);
        }
        return instance;
    }

    private ProfileConditionFactory(DataFetchingEnvironment environment) {
        super("profilePropertyCondition", environment);
    }

    public Condition segmentFilterInputCondition(CDPSegmentFilterInput filterInput) {
        if (filterInput == null) {
            return this.matchAllCondition();
        }
        ArrayList<Condition> rootSubConditions = new ArrayList<Condition>();
        if (filterInput.getNameEquals() != null) {
            rootSubConditions.add(this.propertyCondition("metadata.name", filterInput.getNameEquals(), this.definitionsService));
        }
        if (filterInput.getViewEquals() != null) {
            rootSubConditions.add(this.propertyCondition("metadata.scope", filterInput.getViewEquals(), this.definitionsService));
        }
        if (filterInput.getAndFilters() != null && !filterInput.getAndFilters().isEmpty()) {
            List<Condition> filterAndSubConditions = filterInput.getAndFilters().stream().map(this::segmentFilterInputCondition).collect(Collectors.toList());
            rootSubConditions.add(this.booleanCondition("and", filterAndSubConditions));
        }
        if (filterInput.getOrFilters() != null && !filterInput.getOrFilters().isEmpty()) {
            List<Condition> filterOrSubConditions = filterInput.getOrFilters().stream().map(this::segmentFilterInputCondition).collect(Collectors.toList());
            rootSubConditions.add(this.booleanCondition("or", filterOrSubConditions));
        }
        return this.booleanCondition("and", rootSubConditions);
    }

    public Condition profileFilterInputCondition(CDPProfileFilterInput filterInput, Map<String, Object> filterInputAsMap) {
        if (filterInput == null) {
            return this.matchAllCondition();
        }
        ArrayList<Condition> rootSubConditions = new ArrayList<Condition>();
        if (filterInput.getProfileIDs_contains() != null && !filterInput.getProfileIDs_contains().isEmpty()) {
            rootSubConditions.add(this.propertiesCondition("itemId", "inContains", filterInput.getProfileIDs_contains()));
        }
        if (filterInput.getSegments_contains() != null && filterInput.getSegments_contains().isEmpty()) {
            rootSubConditions.add(ConditionBuilder.create(this.getConditionType("profileSegmentCondition")).parameter("segments", filterInput.getSegments_contains()).parameter("matchType", "in").build());
        }
        if (filterInput.getConsents_contains() != null && !filterInput.getConsents_contains().isEmpty()) {
            rootSubConditions.add(this.consentContainsCondition(filterInput.getConsents_contains()));
        }
        if (filterInput.getLists_contains() != null && filterInput.getLists_contains().isEmpty()) {
            rootSubConditions.add(ConditionBuilder.create(this.getConditionType("profileUserListCondition")).parameter("lists", filterInput.getLists_contains()).parameter("matchType", "in").build());
        }
        if (filterInput.getProperties() != null) {
            Map propertiesFilterAsMap = (Map)filterInputAsMap.get("properties");
            rootSubConditions.add(this.profilePropertiesFilterInputCondition(filterInput.getProperties(), propertiesFilterAsMap));
        }
        if (filterInput.getEvents() != null) {
            Map eventsFilterAsMap = (Map)filterInputAsMap.get("events");
            rootSubConditions.add(this.profileEventsFilterInputCondition(filterInput.getEvents(), eventsFilterAsMap));
        }
        if (filterInput.getInterests() != null) {
            rootSubConditions.add(this.interestFilterInputCondition(filterInput.getInterests()));
        }
        return this.booleanCondition("and", rootSubConditions);
    }

    private Condition consentContainsCondition(List<String> consentsContains) {
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        for (String value : consentsContains) {
            String[] splittedValue = value.split("/", -1);
            Condition scopeCondition = this.propertyCondition("consents." + value + ".scope", splittedValue[0]);
            Condition typeIdentifierCondition = this.propertyCondition("consents." + value + ".typeIdentifier", splittedValue[1]);
            Condition statusCondition = this.propertyCondition("consents." + value + ".status", "GRANTED");
            subConditions.add(this.booleanCondition("and", Arrays.asList(scopeCondition, typeIdentifierCondition, statusCondition)));
        }
        return this.booleanCondition("or", subConditions);
    }

    private Condition buildConditionInterestValue(Double interestValue, String operator) {
        return this.integerPropertyCondition("properties.interests.value", operator, interestValue);
    }

    private Condition interestFilterInputCondition(CDPInterestFilterInput filterInput) {
        ArrayList<Condition> subConditions = new ArrayList<Condition>();
        if (filterInput.getTopic_equals() != null) {
            subConditions.add(this.propertyCondition("properties.interests.key", filterInput.getTopic_equals()));
        }
        if (filterInput.getScore_equals() != null) {
            subConditions.add(this.buildConditionInterestValue(filterInput.getScore_equals(), "equals"));
        }
        if (filterInput.getScore_gt() != null) {
            subConditions.add(this.buildConditionInterestValue(filterInput.getScore_gt(), "greaterThan"));
        }
        if (filterInput.getScore_gte() != null) {
            subConditions.add(this.buildConditionInterestValue(filterInput.getScore_gte(), "greaterThanOrEqualTo"));
        }
        if (filterInput.getScore_lt() != null) {
            subConditions.add(this.buildConditionInterestValue(filterInput.getScore_lt(), "lessThan"));
        }
        if (filterInput.getScore_lte() != null) {
            subConditions.add(this.buildConditionInterestValue(filterInput.getScore_lte(), "lessThanOrEqualTo"));
        }
        if (filterInput.getAnd() != null && !filterInput.getAnd().isEmpty()) {
            subConditions.add(this.filtersToCondition(filterInput.getOr(), this::interestFilterInputCondition, "and"));
        }
        if (filterInput.getOr() != null && !filterInput.getOr().isEmpty()) {
            subConditions.add(this.filtersToCondition(filterInput.getOr(), this::interestFilterInputCondition, "or"));
        }
        Condition nestedCondition = new Condition(this.definitionsService.getConditionType("nestedCondition"));
        nestedCondition.setParameter("path", (Object)"properties.interests");
        nestedCondition.setParameter("subCondition", (Object)this.booleanCondition("and", subConditions));
        return nestedCondition;
    }

    private Condition profileEventsFilterInputCondition(CDPProfileEventsFilterInput filterInput, Map<String, Object> eventsFilterAsMap) {
        List listEventsFilterAsMap;
        Condition pastCondition;
        ArrayList<Condition> rootSubConditions = new ArrayList<Condition>();
        if (filterInput.getNot() != null) {
            Map notEventsFilterAsMap = (Map)eventsFilterAsMap.get("not");
            rootSubConditions.add(ConditionBuilder.create(this.getConditionType("notCondition")).parameter("subCondition", this.profileEventsFilterInputCondition(filterInput.getNot(), notEventsFilterAsMap)).build());
        }
        if ((pastCondition = this.pastEventsCondition(filterInput, eventsFilterAsMap)) != null) {
            rootSubConditions.add(pastCondition);
        }
        if (filterInput.getAnd() != null && !filterInput.getAnd().isEmpty()) {
            listEventsFilterAsMap = (List)eventsFilterAsMap.get("and");
            rootSubConditions.add(this.filtersToCondition(filterInput.getAnd(), listEventsFilterAsMap, this::profileEventsFilterInputCondition, "and"));
        }
        if (filterInput.getOr() != null && !filterInput.getOr().isEmpty()) {
            listEventsFilterAsMap = (List)eventsFilterAsMap.get("or");
            rootSubConditions.add(this.filtersToCondition(filterInput.getOr(), listEventsFilterAsMap, this::profileEventsFilterInputCondition, "or"));
        }
        return this.booleanCondition("and", rootSubConditions);
    }

    private Condition profilePropertiesFilterInputCondition(CDPProfilePropertiesFilterInput filterInput, Map<String, Object> filterAsMap) {
        List listFilterAsMap;
        ArrayList<Condition> rootSubConditions = new ArrayList<Condition>();
        if (filterInput.getAnd() != null && !filterInput.getAnd().isEmpty()) {
            listFilterAsMap = (List)filterAsMap.get("and");
            rootSubConditions.add(this.filtersToCondition(filterInput.getAnd(), listFilterAsMap, this::profilePropertiesFilterInputCondition, "and"));
        }
        if (filterInput.getOr() != null && !filterInput.getOr().isEmpty()) {
            listFilterAsMap = (List)filterAsMap.get("or");
            rootSubConditions.add(this.filtersToCondition(filterInput.getOr(), listFilterAsMap, this::profilePropertiesFilterInputCondition, "or"));
        }
        this.addDynamicProfilePropertiesCondition(filterAsMap, rootSubConditions);
        return this.booleanCondition("and", rootSubConditions);
    }

    private void addDynamicProfilePropertiesCondition(Map<String, Object> filterAsMap, List<Condition> subConditions) {
        ServiceManager serviceManager = (ServiceManager)this.environment.getContext();
        Map propertyTypeMap = serviceManager.getService(ProfileService.class).getTargetPropertyTypes("profiles").stream().collect(Collectors.toMap(Item::getItemId, Function.identity()));
        filterAsMap.forEach((propertyName, propertyValue) -> {
            if (!"and".equals(propertyName) && !"or".equals(propertyName)) {
                this.doAddDynamicProfilePropertiesCondition(null, (String)propertyName, propertyValue, "CDP_ProfilePropertiesFilterInput", propertyTypeMap, filterAsMap, subConditions);
            }
        });
    }

    private void doAddDynamicProfilePropertiesCondition(String path, String propertyName, Object propertyValue, String typeName, Map<String, PropertyType> propertyTypeMap, Map<String, Object> filterAsMap, List<Condition> subConditions) {
        if (propertyTypeMap.containsKey(propertyName) && "set".equals(propertyTypeMap.get(propertyName).getValueTypeId())) {
            Map setFilterAsMap = (Map)filterAsMap.get(propertyName);
            String setTypeName = StringUtils.capitalize(propertyName) + "FilterInput";
            setFilterAsMap.forEach((setPropertyName, setPropertyValue) -> {
                if ("set".equals(((PropertyType)propertyTypeMap.get(propertyName)).getValueTypeId())) {
                    Map<String, PropertyType> childPropertyTypeMap = ((PropertyType)propertyTypeMap.get(propertyName)).getChildPropertyTypes().stream().collect(Collectors.toMap(Item::getItemId, Function.identity()));
                    String setPropertyPath = path != null ? path + "." + propertyName : propertyName;
                    this.doAddDynamicProfilePropertiesCondition(setPropertyPath, (String)setPropertyName, setPropertyValue, setTypeName, childPropertyTypeMap, setFilterAsMap, subConditions);
                } else {
                    subConditions.add(this.createDynamicProfilePropertyCondition((String)setPropertyName, setPropertyValue, setTypeName, path));
                }
            });
        } else {
            subConditions.add(this.createDynamicProfilePropertyCondition(propertyName, propertyValue, typeName, path));
        }
    }

    private Condition createDynamicProfilePropertyCondition(String propertyName, Object value, String typeName, String propertyPath) {
        int index = propertyName.lastIndexOf("_");
        String property = propertyName.substring(0, index);
        String comparisonOperator = propertyName.substring(index + 1);
        if ("distance".equals(comparisonOperator) && value instanceof Map) {
            Object unitObj;
            Object distanceObj;
            Map distanceFilter = (Map)value;
            ConditionBuilder builder = ConditionBuilder.create(this.getConditionType(this.conditionTypeId)).property("properties" + (String)(propertyPath != null ? "." + propertyPath : "") + "." + PropertyNameTranslator.translateFromGraphQLToUnomi(property)).operator(ComparisonConditionTranslator.translateFromGraphQLToUnomi(comparisonOperator));
            Object centerObj = distanceFilter.get("center");
            if (centerObj != null) {
                builder.parameter("center", ((GeoPoint)centerObj).asString());
            }
            if ((distanceObj = distanceFilter.get("distance")) != null) {
                builder.parameter("distance", distanceObj);
            }
            if ((unitObj = distanceFilter.get("unit")) != null) {
                builder.parameter("unit", unitObj.toString().toLowerCase());
            }
            return builder.build();
        }
        String propertyValueType = PropertyValueTypeHelper.getPropertyValueParameterForInputType(typeName, propertyName, this.environment);
        return this.propertyCondition("properties" + (String)(propertyPath != null ? "." + propertyPath : "") + "." + PropertyNameTranslator.translateFromGraphQLToUnomi(property), ComparisonConditionTranslator.translateFromGraphQLToUnomi(comparisonOperator), propertyValueType, value);
    }

    private Condition pastEventsCondition(CDPProfileEventsFilterInput filterInput, Map<String, Object> filterInputAsMap) {
        boolean notEmpty = false;
        ConditionBuilder pastEventConditionBuilder = ConditionBuilder.create(this.getConditionType("pastEventCondition"));
        if (filterInput.getEventFilter() != null) {
            Map eventFilterInputAsMap = (Map)filterInputAsMap.get("eventFilter");
            Condition eventFilterCondition = EventConditionFactory.get(this.environment).eventFilterInputCondition(filterInput.getEventFilter(), eventFilterInputAsMap);
            pastEventConditionBuilder.parameter("eventCondition", eventFilterCondition);
            notEmpty = true;
        }
        if (filterInput.getMinimalCount() != null) {
            pastEventConditionBuilder.parameter("minimumEventCount", filterInput.getMinimalCount());
            notEmpty = true;
        }
        if (filterInput.getMaximalCount() != null) {
            pastEventConditionBuilder.parameter("maximumEventCount", filterInput.getMaximalCount());
            notEmpty = true;
        }
        return notEmpty ? pastEventConditionBuilder.build() : null;
    }
}

