/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.factories;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.graphql.condition.factories.ConditionFactory;
import org.apache.unomi.graphql.types.input.CDPTopicFilterInput;

public class TopicConditionFactory
extends ConditionFactory {
    private static TopicConditionFactory instance;

    public static synchronized TopicConditionFactory get(DataFetchingEnvironment environment) {
        if (instance == null) {
            instance = new TopicConditionFactory(environment);
        }
        return instance;
    }

    private TopicConditionFactory(DataFetchingEnvironment environment) {
        super("topicPropertyCondition", environment);
    }

    public Condition filterInputCondition(CDPTopicFilterInput filterInput, Map<String, Object> filterInputAsMap) {
        if (filterInput == null) {
            return this.matchAllCondition();
        }
        ArrayList<Condition> rootSubConditions = new ArrayList<Condition>();
        if (filterInput.getId_equals() != null) {
            rootSubConditions.add(this.propertyCondition("itemId", filterInput.getId_equals()));
        }
        if (filterInput.getName_equals() != null) {
            rootSubConditions.add(this.propertyCondition("name", filterInput.getName_equals()));
        }
        if (filterInput.getView_equals() != null) {
            rootSubConditions.add(this.propertyCondition("scope", filterInput.getView_equals()));
        }
        if (filterInputAsMap.get("and") != null) {
            List andFilterInputAsMap = (List)filterInputAsMap.get("and");
            rootSubConditions.add(this.filtersToCondition(filterInput.getAnd(), andFilterInputAsMap, this::filterInputCondition, "and"));
        }
        if (filterInputAsMap.get("or") != null) {
            List orFilterInputAsMap = (List)filterInputAsMap.get("or");
            rootSubConditions.add(this.filtersToCondition(filterInput.getOr(), orFilterInputAsMap, this::filterInputCondition, "or"));
        }
        return this.booleanCondition("and", rootSubConditions);
    }
}

