/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.parsers;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.graphql.condition.parsers.SegmentProfileConsentsConditionParser;
import org.apache.unomi.graphql.condition.parsers.SegmentProfileEventsConditionParser;
import org.apache.unomi.graphql.condition.parsers.SegmentProfileIDsConditionParser;
import org.apache.unomi.graphql.condition.parsers.SegmentProfileInterestsConditionParser;
import org.apache.unomi.graphql.condition.parsers.SegmentProfileListConditionParser;
import org.apache.unomi.graphql.condition.parsers.SegmentProfilePropertiesConditionParser;
import org.apache.unomi.graphql.condition.parsers.SegmentProfileSegmentsConditionParser;

public class SegmentConditionParser {
    private static final Predicate<Condition> IS_BOOLEAN_CONDITION_TYPE = condition -> "booleanCondition".equals(condition.getConditionTypeId());
    private static final Predicate<Condition> IS_PROFILE_PROPERTY_CONDITION_TYPE = condition -> "profilePropertyCondition".equals(condition.getConditionTypeId());
    private static final Predicate<Condition> IS_PROFILE_SEGMENT_CONDITION_TYPE = condition -> "profileSegmentCondition".equals(condition.getConditionTypeId());
    private static final Predicate<Condition> IS_PAST_EVENT_CONDITION_TYPE = condition -> "pastEventCondition".equals(condition.getConditionTypeId());
    private static final Predicate<Condition> IS_PROFILE_USER_LIST_CONDITION_TYPE = condition -> "profileUserListCondition".equals(condition.getConditionTypeId());
    private final Condition segmentCondition;
    private final DataFetchingEnvironment environment;
    private Map<String, ConditionDecorator> conditionsContext = new LinkedHashMap<String, ConditionDecorator>();
    private Map<FilterType, List<ConditionDecorator>> groupedConditionsByFilterType = new LinkedHashMap<FilterType, List<ConditionDecorator>>();
    private Map<FilterType, String> rootConditionIdPerFilterType = new LinkedHashMap<FilterType, String>();

    public SegmentConditionParser(Condition segmentCondition, DataFetchingEnvironment environment) {
        this.segmentCondition = segmentCondition;
        this.environment = environment;
    }

    public Map<String, Object> parse() {
        this.populateConditionsContext(this.segmentCondition);
        this.groupConditionsByFilterType();
        this.findRootConditionsByFilterType();
        return this.doParse();
    }

    private Map<String, Object> doParse() {
        LinkedHashMap<String, Object> dataHolder = new LinkedHashMap<String, Object>();
        this.rootConditionIdPerFilterType.forEach((filterType, conditionId) -> {
            ConditionDecorator conditionDecorator = this.conditionsContext.get(conditionId);
            List<Condition> conditionDecorators = this.groupedConditionsByFilterType.get(filterType).stream().map(ConditionDecorator::getCondition).collect(Collectors.toList());
            switch (filterType) {
                case CONSENTS_CONTAINS: {
                    dataHolder.put(filterType.getValue(), new SegmentProfileConsentsConditionParser(conditionDecorators).parse());
                    break;
                }
                case SEGMENTS_CONTAINS: {
                    dataHolder.put(filterType.getValue(), new SegmentProfileSegmentsConditionParser(conditionDecorators).parse());
                    break;
                }
                case PROFILE_IDS_CONTAINS: {
                    dataHolder.put(filterType.getValue(), new SegmentProfileIDsConditionParser(conditionDecorators).parse());
                    break;
                }
                case LISTS_CONTAINS: {
                    dataHolder.put(filterType.getValue(), new SegmentProfileListConditionParser(conditionDecorators).parse());
                    break;
                }
                case EVENTS: {
                    dataHolder.put(filterType.getValue(), new SegmentProfileEventsConditionParser(conditionDecorator.getCondition(), this.environment).parse());
                    break;
                }
                case PROPERTIES: {
                    dataHolder.put(filterType.getValue(), new SegmentProfilePropertiesConditionParser(conditionDecorator.getCondition(), this.environment).parse());
                    break;
                }
                case INTERESTS: {
                    dataHolder.put(filterType.getValue(), new SegmentProfileInterestsConditionParser(conditionDecorator.getCondition()).parse());
                    break;
                }
            }
        });
        return dataHolder;
    }

    private void groupConditionsByFilterType() {
        this.conditionsContext.entrySet().stream().filter(entry -> !IS_BOOLEAN_CONDITION_TYPE.test(((ConditionDecorator)entry.getValue()).getCondition())).forEach(entry -> {
            FilterType filterType = ((ConditionDecorator)entry.getValue()).getFilterType();
            if (!this.groupedConditionsByFilterType.containsKey((Object)filterType)) {
                this.groupedConditionsByFilterType.put(filterType, new ArrayList());
            }
            this.groupedConditionsByFilterType.get((Object)filterType).add((ConditionDecorator)entry.getValue());
        });
    }

    private void findRootConditionsByFilterType() {
        this.groupedConditionsByFilterType.forEach((filterType, conditionDecorators) -> {
            if (conditionDecorators != null && !conditionDecorators.isEmpty()) {
                ConditionDecorator member = (ConditionDecorator)conditionDecorators.get(0);
                do {
                    if (member.getParentId() == null || this.conditionsContext.get(member.getParentId()).getParentId() == null) continue;
                    member = this.conditionsContext.get(member.getParentId());
                } while (this.conditionsContext.get(member.getParentId()).getParentId() != null);
                this.rootConditionIdPerFilterType.put((FilterType)((Object)filterType), member.getId());
            }
        });
    }

    private void populateConditionsContext(Condition condition) {
        this.populateConditionsContext(null, condition);
    }

    private void populateConditionsContext(ConditionDecorator parentDecorator, Condition condition) {
        ConditionDecorator conditionDecorator = this.createConditionDecorator(parentDecorator, condition);
        this.conditionsContext.put(conditionDecorator.getId(), conditionDecorator);
        if (IS_BOOLEAN_CONDITION_TYPE.test(condition)) {
            List subConditions = (List)condition.getParameter("subConditions");
            conditionDecorator.setSubConditions(subConditions);
            subConditions.forEach(subCondition -> this.populateConditionsContext(conditionDecorator, (Condition)subCondition));
        }
    }

    private ConditionDecorator createConditionDecorator(ConditionDecorator parentDecorator, Condition condition) {
        ConditionDecorator decorator = new ConditionDecorator();
        decorator.setId(UUID.randomUUID().toString());
        decorator.setCondition(condition);
        if (parentDecorator != null) {
            decorator.setParentId(parentDecorator.getId());
        }
        if (IS_BOOLEAN_CONDITION_TYPE.test(condition)) {
            decorator.setOperator(condition.getParameter("operator").toString());
            return decorator;
        }
        if (IS_PROFILE_PROPERTY_CONDITION_TYPE.test(condition)) {
            Object propertyName = condition.getParameter("propertyName");
            if (propertyName != null) {
                if (propertyName.toString().startsWith("properties.interests.")) {
                    decorator.setFilterType(FilterType.INTERESTS);
                } else if (propertyName.toString().equals("itemId")) {
                    decorator.setFilterType(FilterType.PROFILE_IDS_CONTAINS);
                } else if (propertyName.toString().startsWith("consents.")) {
                    decorator.setFilterType(FilterType.CONSENTS_CONTAINS);
                } else {
                    decorator.setFilterType(FilterType.PROPERTIES);
                }
            }
        } else if (IS_PROFILE_SEGMENT_CONDITION_TYPE.test(condition)) {
            decorator.setFilterType(FilterType.SEGMENTS_CONTAINS);
        } else if (IS_PAST_EVENT_CONDITION_TYPE.test(condition)) {
            decorator.setFilterType(FilterType.EVENTS);
        } else if (IS_PROFILE_USER_LIST_CONDITION_TYPE.test(condition)) {
            decorator.setFilterType(FilterType.LISTS_CONTAINS);
        } else {
            decorator.setFilterType(FilterType.UNKNOWN);
        }
        return decorator;
    }

    private static enum FilterType {
        CONSENTS_CONTAINS("consents_contains"),
        LISTS_CONTAINS("lists_contains"),
        PROFILE_IDS_CONTAINS("profileIDs_contains"),
        SEGMENTS_CONTAINS("segments_contains"),
        PROPERTIES("properties"),
        EVENTS("events"),
        INTERESTS("interests"),
        UNKNOWN("unknown");

        private String value;

        private FilterType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    private class ConditionDecorator {
        private String id;
        private String parentId;
        private String operator;
        private FilterType filterType;
        private Condition condition;
        private List<Condition> subConditions;

        private ConditionDecorator() {
        }

        String getId() {
            return this.id;
        }

        ConditionDecorator setId(String id) {
            this.id = id;
            return this;
        }

        String getParentId() {
            return this.parentId;
        }

        ConditionDecorator setParentId(String parentId) {
            this.parentId = parentId;
            return this;
        }

        String getOperator() {
            return this.operator;
        }

        ConditionDecorator setOperator(String operator) {
            this.operator = operator;
            return this;
        }

        FilterType getFilterType() {
            return this.filterType;
        }

        ConditionDecorator setFilterType(FilterType filterType) {
            this.filterType = filterType;
            return this;
        }

        Condition getCondition() {
            return this.condition;
        }

        ConditionDecorator setCondition(Condition condition) {
            this.condition = condition;
            return this;
        }

        List<Condition> getSubConditions() {
            return this.subConditions;
        }

        ConditionDecorator setSubConditions(List<Condition> subConditions) {
            this.subConditions = subConditions;
            return this;
        }
    }
}

