/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.parsers;

import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLInputObjectType;
import java.lang.invoke.CallSite;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;
import org.apache.unomi.graphql.schema.PropertyValueTypeHelper;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.utils.DateUtils;
import org.apache.unomi.graphql.utils.ReflectionUtil;

public class SegmentProfileEventsConditionParser {
    private static final Predicate<Condition> IS_BOOLEAN_CONDITION_TYPE = condition -> "booleanCondition".equals(condition.getConditionTypeId());
    private static final Predicate<Condition> IS_NOT_CONDITION_TYPE = condition -> "notCondition".equals(condition.getConditionTypeId());
    private final Condition condition;
    private final DataFetchingEnvironment environment;

    public SegmentProfileEventsConditionParser(Condition condition, DataFetchingEnvironment environment) {
        this.condition = condition;
        this.environment = environment;
    }

    public Map<String, Object> parse() {
        return this.processProfileEvent(this.condition);
    }

    private Map<String, Object> processProfileEvent(Condition condition) {
        LinkedHashMap<String, Object> fieldsMap = new LinkedHashMap<String, Object>();
        ((List)condition.getParameter("subConditions")).forEach(subCondition -> {
            if (IS_BOOLEAN_CONDITION_TYPE.test((Condition)subCondition)) {
                List conditionList = ((List)subCondition.getParameter("subConditions")).stream().map(this::processProfileEvent).collect(Collectors.toList());
                fieldsMap.put(subCondition.getParameter("operator").toString(), conditionList);
            } else {
                Map<String, Object> fieldAsTuple = this.createProfileEventField((Condition)subCondition);
                fieldsMap.putAll(fieldAsTuple);
            }
        });
        return fieldsMap;
    }

    private Map<String, Object> createProfileEventField(Condition condition) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("maximalCount", condition.getParameter("maximumEventCount"));
        result.put("minimalCount", condition.getParameter("minimumEventCount"));
        if (IS_NOT_CONDITION_TYPE.test(condition)) {
            result.put("not", this.processProfileEvent((Condition)condition.getParameter("subCondition")));
        } else {
            result.put("eventFilter", this.processProfileEventProperties((Condition)condition.getParameter("eventCondition")));
        }
        return result;
    }

    private Map<String, Object> processProfileEventProperties(Condition condition) {
        LinkedHashMap<String, Object> fieldsMap = new LinkedHashMap<String, Object>();
        if (IS_BOOLEAN_CONDITION_TYPE.test(condition)) {
            ((List)condition.getParameter("subConditions")).forEach(subCondition -> {
                if (IS_BOOLEAN_CONDITION_TYPE.test((Condition)subCondition)) {
                    List subConditions = (List)subCondition.getParameter("subConditions");
                    if ("and".equals(subCondition.getParameter("operator").toString()) && subConditions.stream().anyMatch(c -> c.getParameter("propertyName") != null && "eventType".equals(c.getParameter("propertyName").toString()))) {
                        this.processDynamicEventField((Condition)subCondition, (Map<String, Object>)fieldsMap);
                    } else {
                        List conditionList = subConditions.stream().map(this::processProfileEventProperties).collect(Collectors.toList());
                        fieldsMap.put(subCondition.getParameter("operator").toString(), conditionList);
                    }
                } else {
                    this.processEventPropertyCondition((Condition)subCondition, (Map<String, Object>)fieldsMap);
                }
            });
        } else {
            this.processEventPropertyCondition(condition, fieldsMap);
        }
        return fieldsMap;
    }

    private void processEventPropertyCondition(Condition condition, Map<String, Object> fieldsMap) {
        Map<String, Object> fieldAsTuple = this.createProfileEventPropertyField(condition);
        if (fieldAsTuple.size() == 2) {
            fieldsMap.put(fieldAsTuple.get("fieldName").toString(), fieldAsTuple.get("fieldValue"));
        }
    }

    private void processDynamicEventField(Condition condition, Map<String, Object> container) {
        List subConditions = (List)condition.getParameter("subConditions");
        String dynamicFieldName = subConditions.stream().filter(subCondition -> "eventType".equals(subCondition.getParameter("propertyName").toString())).map(subCondition -> subCondition.getParameter("propertyValue").toString()).findFirst().orElse(null);
        if (dynamicFieldName != null) {
            GraphQLInputObjectType inputObjectType = (GraphQLInputObjectType)this.environment.getGraphQLSchema().getType(ReflectionUtil.resolveTypeName(CDPEventFilterInput.class));
            String typeName = ((GraphQLInputObjectType)inputObjectType.getFieldDefinition(dynamicFieldName).getType()).getName();
            HashMap<CallSite, Object> dynamicFieldAsMap = new HashMap<CallSite, Object>();
            for (Condition subCondition2 : subConditions) {
                if ("eventType".equals(subCondition2.getParameter("propertyName").toString())) continue;
                String propertyName = subCondition2.getParameter("propertyName").toString().replace("properties.", "");
                String comparisonOperator = subCondition2.getParameter("comparisonOperator").toString();
                String fieldName = PropertyNameTranslator.translateFromUnomiToGraphQL(propertyName) + "_" + comparisonOperator;
                String propertyValueType = PropertyValueTypeHelper.getPropertyValueParameterForInputType(typeName, fieldName, this.environment);
                dynamicFieldAsMap.put((CallSite)((Object)fieldName), subCondition2.getParameter(propertyValueType));
            }
            container.put(dynamicFieldName, dynamicFieldAsMap);
        }
    }

    private Map<String, Object> createProfileEventPropertyField(Condition condition) {
        HashMap<String, Object> tuple = new HashMap<String, Object>();
        String propertyName = condition.getParameter("propertyName").toString();
        if ("timeStamp".equals(propertyName)) {
            String comparisonOperator = condition.getParameter("comparisonOperator").toString();
            if ("equals".equals(comparisonOperator)) {
                tuple.put("fieldName", "cdp_timestamp_equals");
            } else if ("lessThan".equals(comparisonOperator)) {
                tuple.put("fieldName", "cdp_timestamp_lt");
            } else if ("lessThanOrEqualTo".equals(comparisonOperator)) {
                tuple.put("fieldName", "cdp_timestamp_lte");
            } else if ("greaterThan".equals(comparisonOperator)) {
                tuple.put("fieldName", "cdp_timestamp_gt");
            } else {
                tuple.put("fieldName", "cdp_timestamp_gte");
            }
            OffsetDateTime fieldValue = DateUtils.offsetDateTimeFromMap((Map)condition.getParameter("propertyValueDate"));
            tuple.put("fieldValue", fieldValue != null ? fieldValue.toString() : null);
        } else {
            if ("source.itemId".equals(propertyName)) {
                tuple.put("fieldName", "cdp_sourceID_equals");
            } else if ("profileId".equals(propertyName)) {
                tuple.put("fieldName", "cdp_profileID_equals");
            } else if ("itemId".equals(propertyName)) {
                tuple.put("fieldName", "id_equals");
            } else if ("properties.clientId".equals(propertyName)) {
                tuple.put("fieldName", "cdp_clientID_equals");
            }
            tuple.put("fieldValue", condition.getParameter("propertyValue"));
        }
        return tuple;
    }
}

