/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.parsers;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.graphql.schema.ComparisonConditionTranslator;

public class SegmentProfileInterestsConditionParser {
    private static final Predicate<Condition> IS_BOOLEAN_CONDITION_TYPE = condition -> "booleanCondition".equals(condition.getConditionTypeId());
    private final Condition condition;

    public SegmentProfileInterestsConditionParser(Condition condition) {
        this.condition = condition;
    }

    public Map<String, Object> parse() {
        return this.processInterests(this.condition);
    }

    private Map<String, Object> processInterests(Condition condition) {
        LinkedHashMap<String, Object> fieldsMap = new LinkedHashMap<String, Object>();
        ((List)condition.getParameter("subConditions")).forEach(subCondition -> {
            if (IS_BOOLEAN_CONDITION_TYPE.test((Condition)subCondition)) {
                List conditionList = ((List)subCondition.getParameter("subConditions")).stream().map(this::processInterests).collect(Collectors.toList());
                fieldsMap.put(subCondition.getParameter("operator").toString(), conditionList);
            } else {
                Map<String, Object> fieldAsTuple = this.createInterestField((Condition)subCondition);
                fieldsMap.putAll(fieldAsTuple);
            }
        });
        return fieldsMap;
    }

    private Map<String, Object> createInterestField(Condition condition) {
        String comparisonOperator = ComparisonConditionTranslator.translateFromUnomiToGraphQL(condition.getParameter("comparisonOperator").toString());
        HashMap<String, Object> tuple = new HashMap<String, Object>();
        if (!"exists".equals(comparisonOperator)) {
            String fieldName = "score_" + comparisonOperator;
            tuple.put(fieldName, condition.getParameter("propertyValueInteger"));
        }
        tuple.put("topic_equals", condition.getParameter("propertyName").toString().replaceAll("properties.interests.", ""));
        return tuple;
    }
}

