/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.condition.parsers;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.schema.ComparisonConditionTranslator;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.utils.DateUtils;

public class SegmentProfilePropertiesConditionParser {
    private static final Predicate<Condition> IS_BOOLEAN_CONDITION_TYPE = condition -> "booleanCondition".equals(condition.getConditionTypeId());
    private final Condition condition;
    private final Map<String, PropertyType> profilePropertiesAsMap;

    public SegmentProfilePropertiesConditionParser(Condition condition, DataFetchingEnvironment environment) {
        this.condition = condition;
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        this.profilePropertiesAsMap = serviceManager.getService(ProfileService.class).getTargetPropertyTypes("profiles").stream().collect(Collectors.toMap(Item::getItemId, Function.identity()));
    }

    public Map<String, Object> parse() {
        return this.processProfileProperties(this.condition);
    }

    private Map<String, Object> processProfileProperties(Condition condition) {
        LinkedHashMap<String, Object> fieldsMap = new LinkedHashMap<String, Object>();
        ArrayList<Condition> setConditions = new ArrayList<Condition>();
        ((List)condition.getParameter("subConditions")).forEach(subCondition -> {
            if (IS_BOOLEAN_CONDITION_TYPE.test((Condition)subCondition)) {
                List conditionList = ((List)subCondition.getParameter("subConditions")).stream().map(this::processProfileProperties).collect(Collectors.toList());
                fieldsMap.put(subCondition.getParameter("operator").toString(), conditionList);
            } else if (this.isSimpleCondition((Condition)subCondition)) {
                fieldsMap.putAll(this.createProfilePropertiesField((Condition)subCondition));
            } else {
                setConditions.add((Condition)subCondition);
            }
        });
        if (!setConditions.isEmpty()) {
            fieldsMap.putAll(this.processSetConditions(setConditions));
        }
        return fieldsMap;
    }

    private boolean isSimpleCondition(Condition condition) {
        String propertyName = condition.getParameter("propertyName").toString().replaceAll("properties.", "");
        return this.profilePropertiesAsMap.containsKey(propertyName);
    }

    private Map<String, Object> processSetConditions(List<Condition> conditions) {
        TreeMap groupedConditionsByDeepLevels = new TreeMap();
        conditions.forEach(condition -> {
            String propertyName = condition.getParameter("propertyName").toString().replaceAll("properties.", "");
            String[] propertiesPath = propertyName.split("\\.", -1);
            if (!groupedConditionsByDeepLevels.containsKey(propertiesPath.length)) {
                groupedConditionsByDeepLevels.put(propertiesPath.length, new ArrayList());
            }
            ((List)groupedConditionsByDeepLevels.get(propertiesPath.length)).add(condition);
        });
        LinkedHashMap<String, Object> fieldsMap = new LinkedHashMap<String, Object>();
        groupedConditionsByDeepLevels.values().forEach(setConditions -> setConditions.forEach(condition -> {
            String propertyName = condition.getParameter("propertyName").toString().replaceAll("properties.", "");
            String[] propertiesPath = propertyName.split("\\.", -1);
            Map tempFieldsMap = fieldsMap;
            for (int i = 0; i < propertiesPath.length; ++i) {
                if (i == propertiesPath.length - 1) {
                    tempFieldsMap.putAll(this.createProfilePropertiesField(propertiesPath[i], (Condition)condition));
                    continue;
                }
                if (!tempFieldsMap.containsKey(propertiesPath[i])) {
                    tempFieldsMap.put(propertiesPath[i], new HashMap());
                }
                tempFieldsMap = (Map)tempFieldsMap.get(propertiesPath[i]);
            }
        }));
        return fieldsMap;
    }

    private Map<String, Object> createProfilePropertiesField(Condition condition) {
        String propertyName = condition.getParameter("propertyName").toString().replaceAll("properties.", "");
        return this.createProfilePropertiesField(propertyName, condition);
    }

    private Map<String, Object> createProfilePropertiesField(String propertyName, Condition condition) {
        String comparisonOperator = ComparisonConditionTranslator.translateFromUnomiToGraphQL(condition.getParameter("comparisonOperator").toString());
        String fieldName = propertyName + "_" + comparisonOperator;
        Object value = condition.getParameter("propertyValueDate") != null ? DateUtils.offsetDateTimeFromMap((Map)condition.getParameter("propertyValueDate")) : (condition.getParameter("propertyValueInteger") != null ? condition.getParameter("propertyValueInteger") : condition.getParameter("propertyValue"));
        return Collections.singletonMap(fieldName, value);
    }
}

