/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.converters;

import graphql.Scalars;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLType;
import org.apache.unomi.graphql.scalars.DateTimeFunction;
import org.apache.unomi.graphql.scalars.GeoPointFunction;
import org.apache.unomi.graphql.scalars.JSONFunction;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;
import org.apache.unomi.graphql.utils.StringUtils;

public interface UnomiToGraphQLConverter {
    public static GraphQLType convertPropertyType(String type) {
        GraphQLScalarType graphQLType;
        String normalizedType = type;
        boolean isArray = false;
        boolean isMandatory = false;
        if (normalizedType.endsWith("!")) {
            isMandatory = true;
            normalizedType = normalizedType.substring(0, normalizedType.length() - 1);
        }
        if (normalizedType.startsWith("[") && normalizedType.endsWith("]")) {
            isArray = true;
            normalizedType = normalizedType.substring(1, normalizedType.length() - 1);
        }
        switch (normalizedType) {
            case "id": {
                isMandatory = true;
                graphQLType = Scalars.GraphQLID;
                break;
            }
            case "integer": {
                graphQLType = Scalars.GraphQLInt;
                break;
            }
            case "long": {
                graphQLType = Scalars.GraphQLLong;
                break;
            }
            case "float": {
                graphQLType = Scalars.GraphQLFloat;
                break;
            }
            case "set": 
            case "json": {
                graphQLType = JSONFunction.JSON_SCALAR;
                break;
            }
            case "geopoint": {
                graphQLType = GeoPointFunction.GEOPOINT_SCALAR;
                break;
            }
            case "date": {
                graphQLType = DateTimeFunction.DATE_TIME_SCALAR;
                break;
            }
            case "boolean": {
                graphQLType = Scalars.GraphQLBoolean;
                break;
            }
            default: {
                graphQLType = Scalars.GraphQLString;
            }
        }
        graphQLType = isArray ? GraphQLList.list((GraphQLType)graphQLType) : graphQLType;
        return isMandatory ? GraphQLNonNull.nonNull((GraphQLType)graphQLType) : graphQLType;
    }

    public static String convertEventType(String eventType) {
        return StringUtils.capitalize(PropertyNameTranslator.translateFromUnomiToGraphQL(eventType)) + "Event";
    }
}

