/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.graphql.fetchers.BaseDataFetcher;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;

public abstract class BaseConnectionDataFetcher<T>
extends BaseDataFetcher<T> {
    protected ConnectionParams parseConnectionParams(DataFetchingEnvironment environment) {
        return ConnectionParams.create().first(this.parseParam("first", null, environment)).last(this.parseParam("last", null, environment)).after(this.parseParam("after", null, environment)).before(this.parseParam("before", null, environment)).text(this.parseParam("unomi_text", null, environment)).build();
    }

    protected Query buildQuery(Condition condition, List<CDPOrderByInput> orderByInputs, ConnectionParams params) {
        String sortBy;
        Query query = new Query();
        query.setCondition(condition);
        if (params != null) {
            query.setOffset(params.getOffset());
            query.setLimit(params.getSize());
            query.setText(params.getText());
        }
        if (orderByInputs != null && StringUtils.isNotEmpty((CharSequence)(sortBy = orderByInputs.stream().map(CDPOrderByInput::asString).collect(Collectors.joining(","))))) {
            query.setSortby(sortBy);
        }
        return query;
    }
}

