/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.unomi.graphql.utils.GraphQLObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDataFetcher<T>
implements DataFetcher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDataFetcher.class);

    protected <E> E parseObjectParam(String name, Class<E> clazz, DataFetchingEnvironment environment) {
        Object param = environment.getArgument(name);
        if (param == null) {
            return null;
        }
        return (E)GraphQLObjectMapper.getInstance().convertValue(param, clazz);
    }

    protected <K> K parseParam(String name, K defaultValue, DataFetchingEnvironment environment) {
        return (K)Optional.ofNullable(environment.getArgument(name)).orElse(defaultValue);
    }

    protected Date parseDateParam(String name, DataFetchingEnvironment environment) {
        String paramValue = (String)environment.getArgument(name);
        Date param = null;
        if (StringUtils.isNotEmpty((CharSequence)paramValue)) {
            try {
                param = DateFormat.getInstance().parse(paramValue);
            }
            catch (ParseException e) {
                LOGGER.warn("Invalid date format for field '{}': {}", (Object)name, (Object)paramValue);
            }
        }
        return param;
    }
}

