/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers;

public class ConnectionParams {
    public static final int DEFAULT_PAGE_SIZE = 10;
    private Integer first;
    private Integer last;
    private String after;
    private String before;
    private String text;

    private ConnectionParams(Builder builder) {
        this.first = builder.first;
        this.last = builder.last;
        this.after = builder.after;
        this.before = builder.before;
        this.text = builder.text;
        if (this.first != null && this.before != null || this.last != null && this.after != null) {
            throw new IllegalArgumentException("Incorrect params: either 'first' and 'after' or 'last' and 'before' should be used simultaneously");
        }
    }

    public Integer getFirst() {
        return this.first;
    }

    public Integer getLast() {
        return this.last;
    }

    public int getSize() {
        if (this.first != null) {
            return this.first;
        }
        if (this.last != null) {
            return this.last;
        }
        return 10;
    }

    public int getOffset() {
        int beforeInt;
        if (this.after != null) {
            return this.parseInt(this.after, 0);
        }
        if (this.before != null && (beforeInt = this.parseInt(this.before, -1)) > 0) {
            return beforeInt - (this.last != null ? this.last : 10);
        }
        return 0;
    }

    private int parseInt(String after, int defaultValue) {
        try {
            return Integer.parseInt(after);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public String getAfter() {
        return this.after;
    }

    public String getBefore() {
        return this.before;
    }

    public String getText() {
        return this.text;
    }

    public static Builder create() {
        return new Builder();
    }

    public static class Builder {
        private Integer first;
        private Integer last;
        private String after;
        private String before;
        private String text;

        private Builder() {
        }

        public Builder first(Integer first) {
            this.first = first;
            return this;
        }

        public Builder last(Integer last) {
            this.last = last;
            return this;
        }

        public Builder after(String after) {
            this.after = after;
            return this;
        }

        public Builder before(String before) {
            this.before = before;
            return this;
        }

        public Builder text(String text) {
            this.text = text;
            return this;
        }

        public ConnectionParams build() {
            return new ConnectionParams(this);
        }
    }
}

