/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers;

import graphql.schema.DataFetchingEnvironment;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.unomi.graphql.fetchers.DynamicFieldDataFetcher;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.utils.ReflectionUtil;

public class CustomEventOrSetPropertyDataFetcher
extends DynamicFieldDataFetcher<Object> {
    public CustomEventOrSetPropertyDataFetcher(String propertyName) {
        super(propertyName, "custom");
    }

    public Object get(DataFetchingEnvironment environment) throws InvocationTargetException, IllegalAccessException {
        Object value;
        Object source = environment.getSource();
        if (source instanceof Map) {
            value = ((Map)source).get(this.fieldName);
        } else {
            CDPEventInterface eventInterface;
            value = this.getValue(this.fieldName, source, environment);
            if (value == null && source instanceof CDPEventInterface && (value = this.getValue(this.fieldName, (eventInterface = (CDPEventInterface)source).getEvent(), environment)) == null) {
                value = eventInterface.getProperty(this.fieldName);
            }
        }
        return this.inflateType(value);
    }

    private Object getValue(String fieldName, Object object, DataFetchingEnvironment environment) throws IllegalAccessException, InvocationTargetException {
        Method method = ReflectionUtil.findMethod(fieldName, object.getClass());
        if (method != null) {
            return this.invokeMethod(method, object, environment);
        }
        Field field = ReflectionUtil.findField(fieldName, object.getClass());
        if (field != null) {
            return field.get(object);
        }
        return null;
    }

    private Object invokeMethod(Method method, Object object, DataFetchingEnvironment environment) throws InvocationTargetException, IllegalAccessException {
        Class<?>[] paramTypes = method.getParameterTypes();
        if (paramTypes.length == 1 && paramTypes[0].equals(DataFetchingEnvironment.class)) {
            return method.invoke(object, environment);
        }
        if (paramTypes.length == 0) {
            return method.invoke(object, new Object[0]);
        }
        return null;
    }
}

