/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers;

import graphql.schema.DataFetcher;
import java.util.Map;
import org.apache.unomi.api.GeoPoint;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;

public abstract class DynamicFieldDataFetcher<T>
implements DataFetcher<T> {
    protected String fieldName;
    protected String valueTypeId;

    public DynamicFieldDataFetcher(String fieldName, String valueTypeId) {
        this.fieldName = PropertyNameTranslator.translateFromGraphQLToUnomi(fieldName);
        this.valueTypeId = valueTypeId;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getValueTypeId() {
        return this.valueTypeId;
    }

    protected Object inflateType(Object propertyValue) {
        if (propertyValue != null && "geopoint".equals(this.valueTypeId)) {
            if (propertyValue instanceof GeoPoint) {
                return propertyValue;
            }
            if (propertyValue instanceof Map) {
                return GeoPoint.fromMap((Map)((Map)propertyValue));
            }
            if (propertyValue instanceof String) {
                return GeoPoint.fromString((String)((String)propertyValue));
            }
        }
        return propertyValue;
    }
}

