/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.TopicService;
import org.apache.unomi.graphql.condition.factories.TopicConditionFactory;
import org.apache.unomi.graphql.fetchers.BaseConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;
import org.apache.unomi.graphql.types.input.CDPTopicFilterInput;
import org.apache.unomi.graphql.types.output.CDPPageInfo;
import org.apache.unomi.graphql.types.output.CDPTopicConnection;
import org.apache.unomi.graphql.types.output.CDPTopicEdge;

public class FindTopicsConnectionDataFetcher
extends BaseConnectionDataFetcher<CDPTopicConnection> {
    private final CDPTopicFilterInput filterInput;
    private final List<CDPOrderByInput> orderByInput;

    public FindTopicsConnectionDataFetcher(CDPTopicFilterInput filterInput, List<CDPOrderByInput> orderByInput) {
        this.filterInput = filterInput;
        this.orderByInput = orderByInput;
    }

    public CDPTopicConnection get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        TopicService topicService = serviceManager.getService(TopicService.class);
        ConnectionParams params = this.parseConnectionParams(environment);
        Query query = this.buildQuery(this.createCondition(environment), this.orderByInput, params);
        PartialList topicPartialList = topicService.search(query);
        List<CDPTopicEdge> edges = topicPartialList.getList().stream().map(CDPTopicEdge::new).collect(Collectors.toList());
        return new CDPTopicConnection(topicPartialList.getTotalSize(), edges, new CDPPageInfo());
    }

    private Condition createCondition(DataFetchingEnvironment environment) {
        return TopicConditionFactory.get(environment).filterInputCondition(this.filterInput, (Map)environment.getArgument("filter"));
    }
}

