/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.api.Topic;
import org.apache.unomi.api.services.TopicService;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPTopic;

public class TopicDataFetcher
implements DataFetcher<CDPTopic> {
    private final String topicId;

    public TopicDataFetcher(String topicId) {
        this.topicId = topicId;
    }

    public CDPTopic get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        TopicService topicService = serviceManager.getService(TopicService.class);
        Topic topic = topicService.load(this.topicId);
        if (topic != null) {
            return new CDPTopic(topic);
        }
        return null;
    }
}

