/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.consent;

import graphql.schema.DataFetchingEnvironment;
import java.util.Arrays;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.DefinitionsService;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.graphql.condition.factories.EventConditionFactory;
import org.apache.unomi.graphql.fetchers.EventConnectionDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPConsent;
import org.apache.unomi.graphql.types.output.CDPEventConnection;

public class ConsentEventConnectionDataFetcher
extends EventConnectionDataFetcher {
    public CDPEventConnection get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        CDPConsent consent = (CDPConsent)environment.getSource();
        EventConditionFactory factory = EventConditionFactory.get(environment);
        DefinitionsService definitionsService = serviceManager.getService(DefinitionsService.class);
        Condition eventCondition = factory.propertyCondition("eventType", "modifyConsent", definitionsService);
        Condition consentCondition = factory.propertyCondition("target.token", consent.getToken(), definitionsService);
        Condition andCondition = factory.booleanCondition("and", Arrays.asList(eventCondition, consentCondition));
        PartialList events = serviceManager.getService(EventService.class).searchEvents(andCondition, 0, 10);
        return this.createEventConnection((PartialList<Event>)events);
    }
}

