/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.event;

import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.graphql.condition.factories.EventConditionFactory;
import org.apache.unomi.graphql.fetchers.BaseDataFetcher;
import org.apache.unomi.graphql.fetchers.event.UnomiEventPublisher;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.reactivestreams.Publisher;

public class EventListenerSubscriptionFetcher
extends BaseDataFetcher<Publisher<CDPEventInterface>> {
    private UnomiEventPublisher eventPublisher;

    public EventListenerSubscriptionFetcher(UnomiEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    public Publisher<CDPEventInterface> get(DataFetchingEnvironment environment) throws Exception {
        Map filterAsMap = (Map)environment.getArgument("filter");
        if (filterAsMap == null) {
            return this.eventPublisher.createPublisher();
        }
        CDPEventFilterInput filterInput = CDPEventFilterInput.fromMap(filterAsMap);
        Condition filterCondition = EventConditionFactory.get(environment).eventFilterInputCondition(filterInput, filterAsMap);
        return this.eventPublisher.createPublisher(filterCondition);
    }
}

