/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.event;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.graphql.condition.factories.EventConditionFactory;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.fetchers.EventConnectionDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;
import org.apache.unomi.graphql.types.output.CDPEventConnection;

public class FindEventsConnectionDataFetcher
extends EventConnectionDataFetcher {
    private final CDPEventFilterInput filterInput;
    private final List<CDPOrderByInput> orderByInput;

    public FindEventsConnectionDataFetcher(CDPEventFilterInput filterInput, List<CDPOrderByInput> orderByInput) {
        this.filterInput = filterInput;
        this.orderByInput = orderByInput;
    }

    public CDPEventConnection get(DataFetchingEnvironment environment) {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ConnectionParams params = this.parseConnectionParams(environment);
        Map filterInputAsMap = (Map)environment.getArgument("filter");
        Condition condition = EventConditionFactory.get(environment).eventFilterInputCondition(this.filterInput, filterInputAsMap);
        Query query = this.buildQuery(condition, this.orderByInput, params);
        PartialList events = serviceManager.getService(EventService.class).search(query);
        return this.createEventConnection((PartialList<Event>)events);
    }
}

