/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.event;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.Item;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.EventListenerService;
import org.apache.unomi.graphql.schema.CDPEventInterfaceRegister;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.persistence.spi.PersistenceService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.reactivestreams.Publisher;

@Component(immediate=true, service={UnomiEventPublisher.class})
public class UnomiEventPublisher
implements EventListenerService {
    private ServiceRegistration<?> eventServiceRegistration;
    private List<EventPublisherListener> listeners = new CopyOnWriteArrayList<EventPublisherListener>();
    private CDPEventInterfaceRegister eventRegister;
    private PersistenceService persistenceService;

    @Activate
    public void activate(BundleContext bundleContext) {
        String[] interfaces = (String[])Arrays.stream(UnomiEventPublisher.class.getInterfaces()).map(Class::getName).toArray(String[]::new);
        this.eventServiceRegistration = bundleContext.registerService(interfaces, (Object)this, new Hashtable());
    }

    @Deactivate
    public void deactivate() {
        if (this.eventServiceRegistration != null) {
            this.eventServiceRegistration.unregister();
        }
    }

    @Reference
    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    @Reference
    public void setEventInterfaceRegister(CDPEventInterfaceRegister eventRegister) {
        this.eventRegister = eventRegister;
    }

    public Publisher<CDPEventInterface> createPublisher() {
        return this.createPublisher(null);
    }

    public Publisher<CDPEventInterface> createPublisher(Condition filterCondition) {
        EventPublisherListener listener = new EventPublisherListener(filterCondition);
        return Observable.create(emitter -> {
            listener.setEmitter((ObservableEmitter<CDPEventInterface>)emitter);
            this.addListener(listener);
        }).doFinally(() -> this.removeListener(listener)).toFlowable(BackpressureStrategy.BUFFER);
    }

    public boolean canHandle(Event event) {
        return true;
    }

    public int onEvent(Event event) {
        if (!event.isPersistent()) {
            return 0;
        }
        this.listeners.forEach(listener -> {
            if (listener.getCondition() == null || this.persistenceService.testMatch(listener.getCondition(), (Item)event)) {
                listener.getEmitter().onNext((Object)this.eventRegister.getEvent(event));
            }
        });
        return 0;
    }

    public boolean addListener(EventPublisherListener listener) {
        return this.listeners.add(listener);
    }

    public boolean removeListener(EventPublisherListener listener) {
        return this.listeners.remove(listener);
    }

    class EventPublisherListener {
        private ObservableEmitter<CDPEventInterface> emitter;
        private Condition condition;

        EventPublisherListener(Condition condition) {
            this.condition = condition;
        }

        public void setEmitter(ObservableEmitter<CDPEventInterface> emitter) {
            this.emitter = emitter;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public ObservableEmitter<CDPEventInterface> getEmitter() {
            return this.emitter;
        }

        public Condition getCondition() {
            return this.condition;
        }
    }
}

