/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.list;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.graphql.converters.UserListConverter;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPList;
import org.apache.unomi.lists.UserList;
import org.apache.unomi.services.UserListService;

public class GetListDataFetcher
implements DataFetcher<CDPList> {
    private final String listId;

    public GetListDataFetcher(String listId) {
        this.listId = listId;
    }

    public CDPList get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        UserList userList = serviceManager.getService(UserListService.class).load(this.listId);
        return userList != null ? new CDPList(UserListConverter.convertToUnomiList(userList)) : null;
    }
}

