/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.list;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.graphql.condition.factories.ConditionFactory;
import org.apache.unomi.graphql.fetchers.BaseConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPListFilterInput;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;
import org.apache.unomi.graphql.types.output.CDPListConnection;
import org.apache.unomi.services.UserListService;

public class ListConnectionDataFetcher
extends BaseConnectionDataFetcher<CDPListConnection> {
    private final CDPListFilterInput filterInput;
    private final List<CDPOrderByInput> orderByInput;

    public ListConnectionDataFetcher(CDPListFilterInput filterInput, List<CDPOrderByInput> orderByInput) {
        this.filterInput = filterInput;
        this.orderByInput = orderByInput;
    }

    public CDPListConnection get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ConnectionParams params = this.parseConnectionParams(environment);
        Query query = this.buildQuery(this.createCondition(environment), this.orderByInput, params);
        PartialList metadataPartialList = serviceManager.getService(UserListService.class).getListMetadatas(query);
        return new CDPListConnection((PartialList<Metadata>)metadataPartialList);
    }

    private Condition createCondition(DataFetchingEnvironment environment) {
        ConditionFactory factory = new ConditionFactory("userListPropertyCondition", environment);
        return this.createFilterCondition(factory, this.filterInput);
    }

    private Condition createFilterCondition(ConditionFactory factory, CDPListFilterInput filterInput) {
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        if (filterInput.getName_equals() != null) {
            conditions.add(factory.propertyCondition("metadata.name", filterInput.getName_equals()));
        }
        if (filterInput.getView_equals() != null) {
            conditions.add(factory.propertyCondition("metadata.scope", filterInput.getView_equals()));
        }
        if (filterInput.getAnd() != null && !filterInput.getAnd().isEmpty()) {
            conditions.add(factory.filtersToCondition(filterInput.getAnd(), cdpListFilterInput -> this.createFilterCondition(factory, (CDPListFilterInput)cdpListFilterInput), "and"));
        }
        if (filterInput.getOr() != null && !filterInput.getOr().isEmpty()) {
            conditions.add(factory.filtersToCondition(filterInput.getOr(), cdpListFilterInput -> this.createFilterCondition(factory, (CDPListFilterInput)cdpListFilterInput), "or"));
        }
        return factory.booleanCondition("and", conditions);
    }
}

