/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.ProfileAlias;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.graphql.condition.factories.ProfileAliasConditionFactory;
import org.apache.unomi.graphql.fetchers.BaseConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;
import org.apache.unomi.graphql.types.input.CDPProfileAliasFilterInput;
import org.apache.unomi.graphql.types.output.CDPPageInfo;
import org.apache.unomi.graphql.types.output.CDPProfileAliasConnection;
import org.apache.unomi.graphql.types.output.CDPProfileAliasEdge;
import org.apache.unomi.persistence.spi.PersistenceService;

public class FindProfileAliasConnectionDataFetcher
extends BaseConnectionDataFetcher<CDPProfileAliasConnection> {
    private final CDPProfileAliasFilterInput filterInput;
    private final List<CDPOrderByInput> orderByInput;

    public FindProfileAliasConnectionDataFetcher(CDPProfileAliasFilterInput filterInput, List<CDPOrderByInput> orderByInput) {
        this.filterInput = filterInput;
        this.orderByInput = orderByInput;
    }

    public CDPProfileAliasConnection get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        PersistenceService persistenceService = serviceManager.getService(PersistenceService.class);
        ConnectionParams params = this.parseConnectionParams(environment);
        Query query = this.buildQuery(this.createCondition(environment), this.orderByInput, params);
        PartialList partialList = persistenceService.query(query.getCondition(), query.getSortby(), ProfileAlias.class, query.getOffset(), query.getLimit());
        List<CDPProfileAliasEdge> edges = partialList.getList().stream().map(CDPProfileAliasEdge::new).collect(Collectors.toList());
        return new CDPProfileAliasConnection(edges, new CDPPageInfo(), partialList.getTotalSize());
    }

    private Condition createCondition(DataFetchingEnvironment environment) {
        return ProfileAliasConditionFactory.get(environment).filterInputCondition(this.filterInput, (Map)environment.getArgument("filter"));
    }
}

