/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.condition.factories.ProfileConditionFactory;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.fetchers.ProfileConnectionDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;
import org.apache.unomi.graphql.types.input.CDPProfileFilterInput;
import org.apache.unomi.graphql.types.output.CDPProfileConnection;

public class FindProfilesConnectionDataFetcher
extends ProfileConnectionDataFetcher {
    private final CDPProfileFilterInput filterInput;
    private final List<CDPOrderByInput> orderByInput;

    public FindProfilesConnectionDataFetcher(CDPProfileFilterInput filterInput, List<CDPOrderByInput> orderByInput) {
        this.filterInput = filterInput;
        this.orderByInput = orderByInput;
    }

    public CDPProfileConnection get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ConnectionParams params = this.parseConnectionParams(environment);
        Condition condition = ProfileConditionFactory.get(environment).profileFilterInputCondition(this.filterInput, (Map)environment.getArgument("filter"));
        Query query = this.buildQuery(condition, this.orderByInput, params);
        PartialList profiles = serviceManager.getService(ProfileService.class).search(query, Profile.class);
        return this.createProfileConnection((PartialList<Profile>)profiles);
    }
}

