/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPProfileAlias;

public class GetProfileAliasesDataFetcher
implements DataFetcher<List<CDPProfileAlias>> {
    private final String profileId;

    public GetProfileAliasesDataFetcher(String profileId) {
        this.profileId = profileId;
    }

    public List<CDPProfileAlias> get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ProfileService profileService = serviceManager.getService(ProfileService.class);
        PartialList partialList = profileService.findProfileAliases(this.profileId, 0, 100, null);
        return partialList.getList().stream().map(CDPProfileAlias::new).collect(Collectors.toList());
    }
}

