/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import java.util.Map;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.graphql.condition.factories.EventConditionFactory;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.fetchers.EventConnectionDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.types.output.CDPEventConnection;

public class ProfileAllEventsConnectionDataFetcher
extends EventConnectionDataFetcher {
    private final Profile profile;
    private CDPEventFilterInput filterInput;

    public ProfileAllEventsConnectionDataFetcher(Profile profile, CDPEventFilterInput filterInput) {
        this.profile = profile;
        this.filterInput = filterInput;
    }

    public CDPEventConnection get(DataFetchingEnvironment environment) throws Exception {
        Condition condition;
        ConnectionParams params = this.parseConnectionParams(environment);
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        EventConditionFactory eventConditionFactory = EventConditionFactory.get(environment);
        if (this.filterInput == null) {
            condition = eventConditionFactory.propertyCondition("profileId", this.profile.getItemId());
        } else {
            Map filterInputAsMap = (Map)environment.getArgument("filter");
            condition = eventConditionFactory.eventFilterInputCondition(this.filterInput, filterInputAsMap);
        }
        PartialList events = serviceManager.getService(EventService.class).searchEvents(condition, params.getOffset(), params.getSize());
        return this.createEventConnection((PartialList<Event>)events);
    }
}

