/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.fetchers.BaseDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPProfileIDInput;
import org.apache.unomi.graphql.types.output.CDPProfile;

public class ProfileDataFetcher
extends BaseDataFetcher<CDPProfile> {
    private final CDPProfileIDInput profileIDInput;
    private final Boolean createIfMissing;

    public ProfileDataFetcher(CDPProfileIDInput profileIDInput, Boolean createIfMissing) {
        this.profileIDInput = profileIDInput;
        this.createIfMissing = createIfMissing;
    }

    public CDPProfile get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ProfileService profileService = serviceManager.getService(ProfileService.class);
        Profile profile = profileService.load(this.profileIDInput.getId());
        if (profile != null) {
            return new CDPProfile(profile);
        }
        if (this.createIfMissing != null && this.createIfMissing.booleanValue()) {
            profile = new Profile();
            profile.setItemId(this.profileIDInput.getId());
            profile.setItemType("profile");
            profile = profileService.save(profile);
            return new CDPProfile(profile);
        }
        return null;
    }
}

