/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.unomi.api.Profile;
import org.apache.unomi.graphql.types.output.CDPInterest;

public class ProfileInterestsDataFetcher
implements DataFetcher<List<CDPInterest>> {
    private final Profile profile;
    private final List<String> viewIds;

    public ProfileInterestsDataFetcher(Profile profile, List<String> viewIds) {
        this.profile = profile;
        this.viewIds = viewIds;
    }

    public List<CDPInterest> get(DataFetchingEnvironment environment) throws Exception {
        List interests = (List)this.profile.getProperties().get("interests");
        if (interests == null) {
            return Collections.emptyList();
        }
        return interests.stream().map(interest -> {
            String topic = interest.get("key").toString();
            Double score = Double.parseDouble(interest.get("value").toString());
            if (this.viewIds != null && !this.viewIds.isEmpty()) {
                return this.viewIds.contains(topic) ? new CDPInterest(topic, score) : null;
            }
            return new CDPInterest(topic, score);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

