/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.api.Event;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.EventService;
import org.apache.unomi.graphql.condition.factories.EventConditionFactory;
import org.apache.unomi.graphql.fetchers.EventConnectionDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPEventConnection;

public class ProfileLastEventsConnectionDataFetcher
extends EventConnectionDataFetcher {
    private static final int DEFAULT_SIZE = 10;
    private final Profile profile;
    private final Integer count;

    public ProfileLastEventsConnectionDataFetcher(Profile profile, Integer count) {
        this.profile = profile;
        this.count = count != null ? count : 10;
    }

    public CDPEventConnection get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        Condition condition = EventConditionFactory.get(environment).propertyCondition("profileId", this.profile.getItemId());
        PartialList events = serviceManager.getService(EventService.class).searchEvents(condition, 0, this.count.intValue());
        return this.createEventConnection((PartialList<Event>)events);
    }
}

