/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.lists.UserList;
import org.apache.unomi.api.services.UserListService;
import org.apache.unomi.graphql.fetchers.BaseDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPList;

public class ProfileListsDataFetcher
extends BaseDataFetcher<List<CDPList>> {
    private final Profile profile;
    private final List<String> viewIds;

    public ProfileListsDataFetcher(Profile profile, List<String> viewIds) {
        this.profile = profile;
        this.viewIds = viewIds;
    }

    public List<CDPList> get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        UserListService userListService = serviceManager.getService(UserListService.class);
        Map systemProperties = this.profile.getSystemProperties();
        if (systemProperties == null) {
            return null;
        }
        List listIds = (List)systemProperties.get("lists");
        if (listIds == null) {
            return null;
        }
        Stream<Object> stream = listIds.stream();
        List userLists = userListService.getAllUserLists();
        if (this.viewIds != null) {
            stream = stream.filter(this.viewIds::contains);
        }
        return stream.map(viewId -> {
            UserList list = userLists.stream().filter(userList -> viewId.equals(userList.getItemId())).findFirst().orElse(null);
            return list != null ? new CDPList(list) : null;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

