/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.Session;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.condition.factories.ProfileConditionFactory;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPNamedFilterInput;
import org.apache.unomi.graphql.types.output.CDPFilterMatch;

public class ProfileMatchesDataFetcher
implements DataFetcher<List<CDPFilterMatch>> {
    private final Profile profile;
    private final List<CDPNamedFilterInput> namedFilters;

    public ProfileMatchesDataFetcher(Profile profile, List<CDPNamedFilterInput> namedFilters) {
        this.profile = profile;
        this.namedFilters = namedFilters;
    }

    public List<CDPFilterMatch> get(DataFetchingEnvironment environment) throws Exception {
        if (this.namedFilters == null || this.namedFilters.isEmpty()) {
            return Collections.emptyList();
        }
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ProfileService profileService = serviceManager.getService(ProfileService.class);
        Date now = new Date();
        Session session = new Session("profile-matcher-" + now.getTime(), this.profile, now, "digitall");
        List namedFiltersAsMap = (List)environment.getArgument("namedFilters");
        ProfileConditionFactory factory = ProfileConditionFactory.get(environment);
        AtomicInteger i = new AtomicInteger();
        return this.namedFilters.stream().map(filterInput -> {
            Map namedFilterAsMap = null;
            if (namedFiltersAsMap.size() > i.get()) {
                namedFilterAsMap = (Map)namedFiltersAsMap.get(i.get());
            }
            long startTime = System.currentTimeMillis();
            Condition condition = factory.profileFilterInputCondition(filterInput.getFilter(), namedFilterAsMap);
            boolean matches = profileService.matchCondition(condition, this.profile, session);
            i.getAndIncrement();
            return new CDPFilterMatch(filterInput.getName(), matches, System.currentTimeMillis() - startTime);
        }).collect(Collectors.toList());
    }
}

