/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.unomi.api.Metadata;
import org.apache.unomi.api.Profile;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.graphql.fetchers.BaseDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPSegment;

public class ProfileSegmentsDataFetcher
extends BaseDataFetcher<List<CDPSegment>> {
    private final Profile profile;
    private final List<String> viewIds;

    public ProfileSegmentsDataFetcher(Profile profile, List<String> viewIds) {
        this.profile = profile;
        this.viewIds = viewIds;
    }

    public List<CDPSegment> get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        SegmentService segmentService = serviceManager.getService(SegmentService.class);
        List metadata = segmentService.getSegmentMetadatasForProfile(this.profile);
        Stream<Object> stream = metadata.stream();
        if (this.viewIds != null) {
            stream = stream.filter(s -> this.viewIds.contains(s.getScope()));
        }
        return stream.map(s -> this.createCDPSegment((Metadata)s, segmentService)).collect(Collectors.toList());
    }

    private CDPSegment createCDPSegment(Metadata segmentMetadata, SegmentService segmentService) {
        Segment segment = segmentService.getSegmentDefinition(segmentMetadata.getId());
        return new CDPSegment(segment);
    }
}

