/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.profile;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.fetchers.BaseConnectionDataFetcher;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPPageInfo;
import org.apache.unomi.graphql.types.output.CDPPropertyConnection;
import org.apache.unomi.graphql.types.output.CDPPropertyEdge;

public class PropertiesConnectionDataFetcher
extends BaseConnectionDataFetcher<CDPPropertyConnection> {
    public CDPPropertyConnection get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ConnectionParams params = this.parseConnectionParams(environment);
        Collection properties = serviceManager.getService(ProfileService.class).getTargetPropertyTypes("profiles");
        return this.createPropertiesConnection(properties, params);
    }

    private CDPPropertyConnection createPropertiesConnection(Collection<PropertyType> properties, ConnectionParams params) {
        int startIndex = Math.max(0, params.getOffset());
        int lastIndex = Math.min(params.getOffset() + params.getSize(), properties.size());
        if (properties == null || properties.size() == 0 || properties.size() < startIndex || lastIndex <= 0) {
            return new CDPPropertyConnection();
        }
        CDPPageInfo pageInfo = new CDPPageInfo(startIndex > 0, lastIndex < properties.size());
        List<CDPPropertyEdge> edges = new ArrayList<PropertyType>(properties).subList(startIndex, lastIndex).stream().map(CDPPropertyEdge::new).collect(Collectors.toList());
        return new CDPPropertyConnection(Long.valueOf(properties.size()), edges, pageInfo);
    }
}

