/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.segment;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.unomi.api.PartialList;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.api.query.Query;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.graphql.condition.factories.ProfileConditionFactory;
import org.apache.unomi.graphql.fetchers.ConnectionParams;
import org.apache.unomi.graphql.fetchers.SegmentConnectionDataFetcher;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.input.CDPOrderByInput;
import org.apache.unomi.graphql.types.input.CDPSegmentFilterInput;
import org.apache.unomi.graphql.types.output.CDPSegmentConnection;

public class FindSegmentsConnectionDataFetcher
extends SegmentConnectionDataFetcher {
    private final CDPSegmentFilterInput filterInput;
    private final List<CDPOrderByInput> orderByInput;

    public FindSegmentsConnectionDataFetcher(CDPSegmentFilterInput filterInput, List<CDPOrderByInput> orderByInput) {
        this.filterInput = filterInput;
        this.orderByInput = orderByInput;
    }

    public CDPSegmentConnection get(DataFetchingEnvironment environment) {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        ConnectionParams params = this.parseConnectionParams(environment);
        Condition condition = ProfileConditionFactory.get(environment).segmentFilterInputCondition(this.filterInput);
        Query query = this.buildQuery(condition, this.orderByInput, params);
        SegmentService segmentService = serviceManager.getService(SegmentService.class);
        PartialList metas = segmentService.getSegmentMetadatas(query);
        List segmentList = metas.getList().stream().map(meta -> segmentService.getSegmentDefinition(meta.getId())).collect(Collectors.toList());
        PartialList segments = new PartialList(segmentList, metas.getOffset(), metas.getPageSize(), metas.getTotalSize(), metas.getTotalSizeRelation());
        return this.createSegmentConnection((PartialList<Segment>)segments);
    }
}

