/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.fetchers.segment;

import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import org.apache.unomi.api.segments.Segment;
import org.apache.unomi.api.services.SegmentService;
import org.apache.unomi.graphql.services.ServiceManager;
import org.apache.unomi.graphql.types.output.CDPSegment;

public class SegmentDataFetcher
implements DataFetcher<CDPSegment> {
    private final String segmentId;

    public SegmentDataFetcher(String segmentId) {
        this.segmentId = segmentId;
    }

    public CDPSegment get(DataFetchingEnvironment environment) throws Exception {
        ServiceManager serviceManager = (ServiceManager)environment.getContext();
        Segment segment = serviceManager.getService(SegmentService.class).getSegmentDefinition(this.segmentId);
        if (segment != null) {
            return new CDPSegment(segment);
        }
        return null;
    }
}

