/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.providers;

import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLFieldsContainer;
import graphql.schema.GraphQLInputFieldsContainer;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLNamedSchemaElement;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.unomi.graphql.providers.GraphQLFieldVisibilityProvider;

public class CompositeGraphQLFieldVisibility
implements GraphqlFieldVisibility {
    private final List<GraphQLFieldVisibilityProvider> providers;

    public CompositeGraphQLFieldVisibility(List<GraphQLFieldVisibilityProvider> providers) {
        this.providers = providers;
        if (providers != null && !providers.isEmpty()) {
            providers.sort(Comparator.comparingInt(GraphQLFieldVisibilityProvider::getPriority).reversed());
        }
    }

    public List<GraphQLFieldDefinition> getFieldDefinitions(GraphQLFieldsContainer fieldsContainer) {
        if (this.providers == null) {
            return new ArrayList<GraphQLFieldDefinition>();
        }
        return this.providers.stream().map(provider -> provider.getGraphQLFieldVisibility().getFieldDefinitions(fieldsContainer)).reduce(CompositeGraphQLFieldVisibility::intersect).orElse(new ArrayList());
    }

    public GraphQLFieldDefinition getFieldDefinition(GraphQLFieldsContainer fieldsContainer, String fieldName) {
        if (this.providers == null) {
            return null;
        }
        List list = this.providers.stream().map(provider -> provider.getGraphQLFieldVisibility().getFieldDefinition(fieldsContainer, fieldName)).collect(Collectors.toList());
        return (GraphQLFieldDefinition)CompositeGraphQLFieldVisibility.extractWithPriority(list);
    }

    public List<GraphQLInputObjectField> getFieldDefinitions(GraphQLInputFieldsContainer fieldsContainer) {
        if (this.providers == null) {
            return new ArrayList<GraphQLInputObjectField>();
        }
        return this.providers.stream().map(provider -> provider.getGraphQLFieldVisibility().getFieldDefinitions(fieldsContainer)).reduce(CompositeGraphQLFieldVisibility::intersect).orElse(new ArrayList());
    }

    public GraphQLInputObjectField getFieldDefinition(GraphQLInputFieldsContainer fieldsContainer, String fieldName) {
        if (this.providers == null) {
            return null;
        }
        List list = this.providers.stream().map(provider -> provider.getGraphQLFieldVisibility().getFieldDefinition(fieldsContainer, fieldName)).collect(Collectors.toList());
        return (GraphQLInputObjectField)CompositeGraphQLFieldVisibility.extractWithPriority(list);
    }

    private static <T extends GraphQLNamedSchemaElement> List<T> intersect(List<T> prev, List<T> curr) {
        return curr.stream().distinct().filter(prev::contains).collect(Collectors.toList());
    }

    private static <T> T extractWithPriority(List<T> list) {
        boolean noItems;
        boolean anyBlocks = list.stream().anyMatch(Objects::isNull);
        boolean bl = noItems = list.size() == 0;
        if (anyBlocks || noItems) {
            return null;
        }
        return list.get(0);
    }
}

