/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.Event;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.types.output.UnomiEvent;
import org.apache.unomi.graphql.utils.ReflectionUtil;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={CDPEventInterfaceRegister.class})
public class CDPEventInterfaceRegister {
    private ConcurrentHashMap<String, Class<? extends CDPEventInterface>> events = new ConcurrentHashMap();

    public void register(Class<? extends CDPEventInterface> eventMember) {
        this.events.put(this.getEventType(eventMember), eventMember);
    }

    public CDPEventInterface getEvent(Event event) {
        if (!this.events.containsKey(event.getEventType())) {
            return new UnomiEvent(event);
        }
        try {
            return this.events.get(event.getEventType()).getConstructor(Event.class).newInstance(event);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getEventType(Class<? extends CDPEventInterface> clazz) {
        return this.transformEventType(ReflectionUtil.resolveTypeName(clazz));
    }

    private String transformEventType(String eventType) {
        int index = eventType.indexOf("_");
        char[] chars = eventType.substring(index + 1).toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return eventType.substring(0, index).toLowerCase() + "_" + new String(chars);
    }
}

