/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.Profile;
import org.apache.unomi.graphql.types.output.CDPProfileInterface;
import org.apache.unomi.graphql.utils.ReflectionUtil;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={CDPProfileInterfaceRegister.class})
public class CDPProfileInterfaceRegister {
    private ConcurrentHashMap<String, Class<? extends CDPProfileInterface>> profiles = new ConcurrentHashMap();

    public void register(Class<? extends CDPProfileInterface> profileMember) {
        this.profiles.put(this.getProfileType(profileMember), profileMember);
    }

    public <PROFILE extends Profile> CDPProfileInterface getProfile(PROFILE profile) {
        try {
            return this.profiles.get(profile.getItemType()).getConstructor(Profile.class).newInstance(profile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getProfileType(Class<? extends CDPProfileInterface> clazz) {
        return this.transformProfileType(ReflectionUtil.resolveTypeName(clazz));
    }

    private String transformProfileType(String eventType) {
        int index = eventType.indexOf("_");
        return eventType.substring(index + 1).toLowerCase();
    }
}

