/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.graphql.types.output.CDPPropertyInterface;
import org.apache.unomi.graphql.utils.ReflectionUtil;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={CDPPropertyInterfaceRegister.class})
public class CDPPropertyInterfaceRegister {
    private ConcurrentHashMap<String, Class<? extends CDPPropertyInterface>> properties = new ConcurrentHashMap();

    public void register(Class<? extends CDPPropertyInterface> propertyMember) {
        this.properties.put(this.getPropertyType(propertyMember), propertyMember);
    }

    public CDPPropertyInterface getProperty(PropertyType type) {
        if (!this.properties.containsKey(type.getValueTypeId())) {
            return null;
        }
        try {
            return this.properties.get(type.getValueTypeId()).getConstructor(PropertyType.class).newInstance(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String getPropertyType(Class<? extends CDPPropertyInterface> clazz) {
        return ReflectionUtil.getUnomiType(clazz);
    }
}

