/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema;

import com.fasterxml.jackson.core.JsonProcessingException;
import graphql.annotations.AnnotationsSchemaCreator;
import graphql.annotations.processor.GraphQLAnnotations;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.language.InputObjectTypeDefinition;
import graphql.schema.DataFetcher;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.visibility.GraphqlFieldVisibility;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.unomi.api.PropertyType;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.converters.UnomiToGraphQLConverter;
import org.apache.unomi.graphql.fetchers.CustomEventOrSetPropertyDataFetcher;
import org.apache.unomi.graphql.fetchers.CustomerPropertyDataFetcher;
import org.apache.unomi.graphql.fetchers.DynamicFieldDataFetcher;
import org.apache.unomi.graphql.fetchers.event.EventListenerSubscriptionFetcher;
import org.apache.unomi.graphql.fetchers.event.UnomiEventPublisher;
import org.apache.unomi.graphql.providers.CompositeGraphQLFieldVisibility;
import org.apache.unomi.graphql.providers.GraphQLAdditionalTypesProvider;
import org.apache.unomi.graphql.providers.GraphQLCodeRegistryProvider;
import org.apache.unomi.graphql.providers.GraphQLExtensionsProvider;
import org.apache.unomi.graphql.providers.GraphQLFieldVisibilityProvider;
import org.apache.unomi.graphql.providers.GraphQLMutationProvider;
import org.apache.unomi.graphql.providers.GraphQLQueryProvider;
import org.apache.unomi.graphql.providers.GraphQLSubscriptionProvider;
import org.apache.unomi.graphql.providers.GraphQLTypeFunctionProvider;
import org.apache.unomi.graphql.schema.PropertyFilterUtils;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;
import org.apache.unomi.graphql.schema.json.JSONObjectType;
import org.apache.unomi.graphql.schema.json.JSONSchema;
import org.apache.unomi.graphql.schema.json.JSONType;
import org.apache.unomi.graphql.schema.json.JSONTypeFactory;
import org.apache.unomi.graphql.types.input.CDPEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPEventInput;
import org.apache.unomi.graphql.types.input.CDPEventProcessor;
import org.apache.unomi.graphql.types.input.CDPPersonaInput;
import org.apache.unomi.graphql.types.input.CDPProfilePropertiesFilterInput;
import org.apache.unomi.graphql.types.input.CDPProfileUpdateEventFilterInput;
import org.apache.unomi.graphql.types.input.CDPProfileUpdateEventInput;
import org.apache.unomi.graphql.types.input.CDPUnomiEventInput;
import org.apache.unomi.graphql.types.input.EventFilterInputMarker;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.types.output.CDPPersona;
import org.apache.unomi.graphql.types.output.CDPProfile;
import org.apache.unomi.graphql.types.output.RootMutation;
import org.apache.unomi.graphql.types.output.RootQuery;
import org.apache.unomi.graphql.utils.GraphQLObjectMapper;
import org.apache.unomi.graphql.utils.ReflectionUtil;
import org.apache.unomi.graphql.utils.StringUtils;
import org.apache.unomi.schema.api.JsonSchemaWrapper;
import org.apache.unomi.schema.api.SchemaService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQLSchemaProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)GraphQLSchemaProvider.class.getName());
    private final ProfileService profileService;
    private final SchemaService schemaService;
    private final List<GraphQLTypeFunctionProvider> typeFunctionProviders;
    private final List<GraphQLExtensionsProvider> extensionsProviders;
    private final List<GraphQLAdditionalTypesProvider> additionalTypesProviders;
    private final List<GraphQLQueryProvider> queryProviders;
    private final List<GraphQLMutationProvider> mutationProviders;
    private final List<GraphQLSubscriptionProvider> subscriptionProviders;
    private final List<GraphQLFieldVisibilityProvider> fieldVisibilityProviders;
    private final GraphQLCodeRegistryProvider codeRegistryProvider;
    private final UnomiEventPublisher eventPublisher;
    private GraphQLAnnotations graphQLAnnotations;
    private Set<Class<?>> additionalTypes = new HashSet();

    private GraphQLSchemaProvider(Builder builder) {
        this.profileService = builder.profileService;
        this.schemaService = builder.schemaService;
        this.eventPublisher = builder.eventPublisher;
        this.typeFunctionProviders = builder.typeFunctionProviders;
        this.extensionsProviders = builder.extensionsProviders;
        this.additionalTypesProviders = builder.additionalTypesProviders;
        this.queryProviders = builder.queryProviders;
        this.mutationProviders = builder.mutationProviders;
        this.subscriptionProviders = builder.subscriptionProviders;
        this.codeRegistryProvider = builder.codeRegistryProvider;
        this.fieldVisibilityProviders = builder.fieldVisibilityProviders;
    }

    public GraphQLSchema createSchema() {
        this.graphQLAnnotations = new GraphQLAnnotations();
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        this.registerTypeFunctions();
        this.configureElementsContainer();
        this.registerDynamicFields(schemaBuilder);
        this.registerExtensions();
        this.registerAdditionalTypes();
        this.transformQuery();
        this.transformMutations();
        this.configureFieldVisibility();
        this.configureCodeRegister();
        AnnotationsSchemaCreator.Builder annotationsSchema = AnnotationsSchemaCreator.newAnnotationsSchema();
        if (this.additionalTypes != null) {
            annotationsSchema.additionalTypes(this.additionalTypes);
        }
        this.createSubscriptionSchema(schemaBuilder);
        return annotationsSchema.setGraphQLSchemaBuilder(schemaBuilder).query(RootQuery.class).mutation(RootMutation.class).setAnnotationsProcessor(this.graphQLAnnotations).build();
    }

    private void createSubscriptionSchema(GraphQLSchema.Builder schemaBuilder) {
        GraphQLInputObjectType eventFilterInputType = (GraphQLInputObjectType)this.getFromTypeRegistry("CDP_EventFilterInput");
        GraphQLInterfaceType eventInterfaceType = (GraphQLInterfaceType)this.getFromTypeRegistry("CDP_EventInterface");
        GraphQLObjectType cdpSubscription = GraphQLObjectType.newObject().name("CDP_Subscription").field(GraphQLFieldDefinition.newFieldDefinition().argument(GraphQLArgument.newArgument().name("filter").type((GraphQLInputType)eventFilterInputType).build()).name("eventListener").type((GraphQLOutputType)eventInterfaceType).build()).build();
        this.graphQLAnnotations.getContainer().getCodeRegistryBuilder().dataFetcher(FieldCoordinates.coordinates((String)"CDP_Subscription", (String)"eventListener"), (DataFetcher)new EventListenerSubscriptionFetcher(this.eventPublisher));
        if (this.subscriptionProviders != null && !this.subscriptionProviders.isEmpty()) {
            for (GraphQLSubscriptionProvider subscriptionProvider : this.subscriptionProviders) {
                Set<GraphQLFieldDefinition> subscriptions = subscriptionProvider.getSubscriptions(this.graphQLAnnotations);
                if (subscriptions == null) continue;
                cdpSubscription = cdpSubscription.transform(builder -> subscriptions.forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0)));
            }
        }
        schemaBuilder.subscription(cdpSubscription);
    }

    public Set<Class<?>> getAdditionalTypes() {
        return this.additionalTypes;
    }

    private void registerTypeFunctions() {
        if (this.typeFunctionProviders != null && !this.typeFunctionProviders.isEmpty()) {
            for (GraphQLTypeFunctionProvider provider : this.typeFunctionProviders) {
                if (provider == null || provider.getTypeFunctions() == null) continue;
                provider.getTypeFunctions().forEach(arg_0 -> ((GraphQLAnnotations)this.graphQLAnnotations).registerTypeFunction(arg_0));
            }
        }
    }

    private void registerDynamicFields(GraphQLSchema.Builder schemaBuilder) {
        if (this.additionalTypesProviders != null && !this.additionalTypesProviders.isEmpty()) {
            for (GraphQLAdditionalTypesProvider typeProvider : this.additionalTypesProviders) {
                if (typeProvider == null || typeProvider.getAdditionalInputTypes() == null) continue;
                typeProvider.getAdditionalInputTypes().forEach(additionalType -> {
                    String typeName = ReflectionUtil.resolveTypeName(additionalType);
                    GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name(typeName).fields(this.getInputObjectType((Class<?>)additionalType).getFieldDefinitions());
                    this.registerInTypeRegistry(typeName, (GraphQLType)builder.build());
                });
            }
        }
        Collection profilePropertyTypes = this.profileService.getTargetPropertyTypes("profiles");
        Collection profileDefinitionTypes = profilePropertyTypes.stream().map(x$0 -> new PropertyTypeDefinitionType((PropertyType)x$0)).collect(Collectors.toList());
        this.registerDynamicInputFilterFields("CDP_ProfilePropertiesFilterInput", CDPProfilePropertiesFilterInput.class, profileDefinitionTypes);
        this.registerDynamicInputFilterFields("CDP_ProfileUpdateEventFilterInput", CDPProfileUpdateEventFilterInput.class, profileDefinitionTypes);
        this.registerDynamicInputFields("CDP_ProfileUpdateEventInput", CDPProfileUpdateEventInput.class, (Collection<DefinitionType>)profileDefinitionTypes);
        this.registerDynamicEventFilterInputFields();
        this.registerDynamicOutputFields("CDP_Profile", CDPProfile.class, CustomerPropertyDataFetcher.class, (Collection<DefinitionType>)profileDefinitionTypes);
        this.registerDynamicInputFields("CDP_PersonaInput", CDPPersonaInput.class, (Collection<DefinitionType>)profileDefinitionTypes);
        this.registerDynamicOutputFields("CDP_Persona", CDPPersona.class, CustomerPropertyDataFetcher.class, (Collection<DefinitionType>)profileDefinitionTypes);
        this.registerDynamicUnomiInputEvents(schemaBuilder);
        this.registerDynamicUnomiOutputEvents(schemaBuilder);
        this.registerDynamicEventInputFields();
    }

    private void registerDynamicUnomiInputEvents(GraphQLSchema.Builder schemaBuilder) {
        List unomiEventTypes = this.schemaService.getSchemasByTarget("events").stream().map(jsonSchemaWrapper -> GraphQLSchemaProvider.buildJSONSchema(jsonSchemaWrapper, this.schemaService)).collect(Collectors.toList());
        if (!unomiEventTypes.isEmpty()) {
            for (JSONSchema unomiEventType : unomiEventTypes) {
                GraphQLInputObjectType objectType;
                String typeName = UnomiToGraphQLConverter.convertEventType(unomiEventType.getName()) + "Input";
                if (!this.graphQLAnnotations.getContainer().getTypeRegistry().containsKey(typeName)) {
                    objectType = this.createDynamicEventInputType(new JSONTypeDefinitionType(unomiEventType.getName(), unomiEventType.getRootTypes()), new ArrayDeque<String>());
                } else {
                    objectType = (GraphQLInputObjectType)this.getFromTypeRegistry(typeName);
                    this.registerDynamicInputFields(typeName, objectType, new JSONTypeDefinitionType(unomiEventType.getName(), unomiEventType.getRootTypes()).getSubTypes());
                }
                if (objectType == null) continue;
                schemaBuilder.additionalType((GraphQLType)objectType);
            }
        }
    }

    private void registerDynamicUnomiOutputEvents(GraphQLSchema.Builder schemaBuilder) {
        List unomiEventTypes = this.schemaService.getSchemasByTarget("events").stream().map(jsonSchemaWrapper -> GraphQLSchemaProvider.buildJSONSchema(jsonSchemaWrapper, this.schemaService)).collect(Collectors.toList());
        if (!unomiEventTypes.isEmpty()) {
            GraphQLCodeRegistry.Builder codeRegisterBuilder = this.graphQLAnnotations.getContainer().getCodeRegistryBuilder();
            for (JSONSchema unomiEventType : unomiEventTypes) {
                GraphQLObjectType objectType;
                String typeName = UnomiToGraphQLConverter.convertEventType(unomiEventType.getName());
                if (!this.graphQLAnnotations.getContainer().getTypeRegistry().containsKey(typeName)) {
                    objectType = this.createDynamicEventOutputType(new JSONTypeDefinitionType(unomiEventType.getName(), unomiEventType.getRootTypes()), codeRegisterBuilder);
                } else {
                    objectType = (GraphQLObjectType)this.getFromTypeRegistry(typeName);
                    this.registerDynamicOutputFields(typeName, objectType, CustomerPropertyDataFetcher.class, new JSONTypeDefinitionType(unomiEventType.getName(), unomiEventType.getRootTypes()).getSubTypes());
                }
                if (objectType == null) continue;
                schemaBuilder.additionalType((GraphQLType)objectType);
            }
        }
    }

    private void registerDynamicInputFilterFields(String typeName, Class<?> annotatedClass, Collection<DefinitionType> propertyTypes) {
        GraphQLInputObjectType originalObject = this.getInputObjectType(annotatedClass);
        List<GraphQLInputObjectField> inputObjectFields = PropertyFilterUtils.buildInputPropertyFilters(propertyTypes, this.graphQLAnnotations);
        GraphQLInputObjectType transformedObjectType = originalObject.transform(builder -> inputObjectFields.forEach(arg_0 -> ((GraphQLInputObjectType.Builder)builder).field(arg_0)));
        this.registerInTypeRegistry(typeName, (GraphQLType)transformedObjectType);
    }

    private void registerDynamicOutputFields(String graphQLTypeName, Class<?> annotatedClass, Class<? extends DynamicFieldDataFetcher> fetcherClass, Collection<DefinitionType> propertyTypes) {
        GraphQLObjectType objectType = this.graphQLAnnotations.object(annotatedClass);
        this.registerDynamicOutputFields(graphQLTypeName, objectType, fetcherClass, propertyTypes);
    }

    private void registerDynamicOutputFields(String graphQLTypeName, GraphQLObjectType graphQLObjectType, Class<? extends DynamicFieldDataFetcher> fetcherClass, Collection<DefinitionType> propertyTypes) {
        GraphQLCodeRegistry.Builder codeRegisterBuilder = this.graphQLAnnotations.getContainer().getCodeRegistryBuilder();
        ArrayList fieldDefinitions = new ArrayList();
        propertyTypes.forEach(propertyType -> {
            String propertyName = PropertyNameTranslator.translateFromUnomiToGraphQL(propertyType.getName());
            if (propertyType.hasSubTypes()) {
                String typeName = StringUtils.capitalize(propertyName);
                if (!this.graphQLAnnotations.getContainer().getTypeRegistry().containsKey(typeName)) {
                    GraphQLObjectType objectType = this.createDynamicSetOutputType((DefinitionType)propertyType, codeRegisterBuilder, null);
                    if (objectType != null) {
                        fieldDefinitions.add(GraphQLFieldDefinition.newFieldDefinition().type((GraphQLOutputType)objectType).name(propertyName).build());
                    }
                } else {
                    fieldDefinitions.add(GraphQLFieldDefinition.newFieldDefinition().type((GraphQLOutputType)((GraphQLObjectType)this.getFromTypeRegistry(typeName))).name(propertyName).build());
                }
            } else {
                fieldDefinitions.add(GraphQLFieldDefinition.newFieldDefinition().type((GraphQLOutputType)UnomiToGraphQLConverter.convertPropertyType(propertyType.getTypeId())).name(propertyName).build());
            }
            try {
                DataFetcher dataFetcher = (DataFetcher)fetcherClass.getConstructor(String.class, String.class).newInstance(propertyName, propertyType.getTypeId());
                codeRegisterBuilder.dataFetcher(FieldCoordinates.coordinates((String)graphQLTypeName, (String)propertyName), dataFetcher);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Error creating a data fetcher with class %s for field %s", fetcherClass.getName(), propertyName), e);
            }
        });
        if (!fieldDefinitions.isEmpty()) {
            GraphQLObjectType transformedObjectType = graphQLObjectType.transform(builder -> fieldDefinitions.forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0)));
            this.registerInTypeRegistry(graphQLTypeName, (GraphQLType)transformedObjectType);
        }
    }

    private GraphQLObjectType createDynamicSetOutputType(DefinitionType propertyType, GraphQLCodeRegistry.Builder codeRegisterBuilder, String parentName) {
        return this.createDynamicOutputType(parentName != null ? parentName : propertyType.getName(), propertyType.getSubTypes(), null, codeRegisterBuilder);
    }

    private GraphQLObjectType createDynamicEventOutputType(DefinitionType eventType, GraphQLCodeRegistry.Builder codeRegisterBuilder) {
        HashSet<Class> interfaces = new HashSet<Class>();
        interfaces.add(CDPEventInterface.class);
        return this.createDynamicOutputType(UnomiToGraphQLConverter.convertEventType(eventType.getName()), eventType.getSubTypes(), interfaces, codeRegisterBuilder);
    }

    private GraphQLObjectType createDynamicOutputType(String name, List<DefinitionType> propertyTypes, Set<Class> interfaces, GraphQLCodeRegistry.Builder codeRegisterBuilder) {
        String typeName = StringUtils.capitalize(PropertyNameTranslator.translateFromUnomiToGraphQL(name));
        GraphQLObjectType.Builder dynamicTypeBuilder = GraphQLObjectType.newObject().name(typeName);
        ArrayList fieldDefinitions = new ArrayList();
        if (interfaces != null && !interfaces.isEmpty()) {
            for (Class anInterface : interfaces) {
                GraphQLInterfaceType graphQLInterface = (GraphQLInterfaceType)this.getOutputType(anInterface);
                if (graphQLInterface == null) continue;
                dynamicTypeBuilder.withInterface(graphQLInterface);
                graphQLInterface.getFieldDefinitions().forEach(fieldDefinition -> {
                    fieldDefinitions.add(fieldDefinition);
                    String propertyName = fieldDefinition.getName();
                    CustomEventOrSetPropertyDataFetcher dataFetcher = new CustomEventOrSetPropertyDataFetcher(propertyName);
                    codeRegisterBuilder.dataFetcher(FieldCoordinates.coordinates((String)typeName, (String)propertyName), (DataFetcher)dataFetcher);
                });
            }
        }
        if (propertyTypes != null && !propertyTypes.isEmpty()) {
            propertyTypes.forEach(childPropertyType -> {
                boolean isSet = childPropertyType.hasSubTypes();
                String childPropertyName = PropertyNameTranslator.translateFromUnomiToGraphQL(childPropertyType.getName());
                Object objectType = null;
                objectType = isSet ? this.createDynamicSetOutputType((DefinitionType)childPropertyType, codeRegisterBuilder, typeName + "_" + childPropertyName) : (GraphQLOutputType)UnomiToGraphQLConverter.convertPropertyType(childPropertyType.getTypeId());
                if (objectType != null) {
                    fieldDefinitions.add(GraphQLFieldDefinition.newFieldDefinition().name(childPropertyName).type(objectType).build());
                    codeRegisterBuilder.dataFetcher(FieldCoordinates.coordinates((String)typeName, (String)childPropertyName), (DataFetcher)new CustomEventOrSetPropertyDataFetcher(childPropertyName));
                }
            });
        }
        if (!fieldDefinitions.isEmpty()) {
            fieldDefinitions.forEach(arg_0 -> ((GraphQLObjectType.Builder)dynamicTypeBuilder).field(arg_0));
            GraphQLObjectType objectType = dynamicTypeBuilder.build();
            this.registerInTypeRegistry(typeName, (GraphQLType)objectType);
            return objectType;
        }
        return null;
    }

    private GraphQLInputObjectType createDynamicEventInputType(DefinitionType eventType, Deque<String> typeStack) {
        return this.createDynamicInputType(UnomiToGraphQLConverter.convertEventType(eventType.getName()), eventType.getSubTypes(), true, typeStack);
    }

    private GraphQLInputObjectType createDynamicSetInputType(DefinitionType propertyType, String parentName, Deque<String> typeStack) {
        return this.createDynamicInputType(parentName != null ? parentName : propertyType.getName(), propertyType.getSubTypes(), false, typeStack);
    }

    private GraphQLInputObjectType createDynamicInputType(String name, List<DefinitionType> propertyTypes, boolean isEvent, Deque<String> typeStack) {
        if (typeStack.contains(name)) {
            LOGGER.error("Loop detected when creating dynamic input types {} !", typeStack);
            return null;
        }
        typeStack.push(name);
        String typeName = StringUtils.capitalize(PropertyNameTranslator.translateFromUnomiToGraphQL(name)) + "Input";
        GraphQLInputObjectType.Builder dynamicTypeBuilder = GraphQLInputObjectType.newInputObject().name(typeName);
        if (isEvent) {
            dynamicTypeBuilder.definition(InputObjectTypeDefinition.newInputObjectDefinition().additionalData("eventProcessorClass", CDPUnomiEventInput.class.getName()).build());
        }
        ArrayList fieldDefinitions = new ArrayList();
        if (propertyTypes != null && !propertyTypes.isEmpty()) {
            propertyTypes.forEach(childPropertyType -> {
                boolean isSet = childPropertyType.hasSubTypes();
                String childPropertyName = PropertyNameTranslator.translateFromUnomiToGraphQL(childPropertyType.getName());
                Object objectType = isSet ? this.createDynamicSetInputType((DefinitionType)childPropertyType, typeName + "_" + childPropertyName, typeStack) : (GraphQLInputType)UnomiToGraphQLConverter.convertPropertyType(childPropertyType.getTypeId());
                if (objectType != null) {
                    fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(childPropertyName).type(objectType).build());
                }
            });
        }
        if (!fieldDefinitions.isEmpty()) {
            fieldDefinitions.forEach(arg_0 -> ((GraphQLInputObjectType.Builder)dynamicTypeBuilder).field(arg_0));
            GraphQLInputObjectType objectType = dynamicTypeBuilder.build();
            this.registerInTypeRegistry(typeName, (GraphQLType)objectType);
            typeStack.pop();
            return objectType;
        }
        typeStack.pop();
        return null;
    }

    private void registerDynamicInputFields(String graphQLTypeName, Class<?> clazz, Collection<DefinitionType> propertyTypes) {
        GraphQLInputObjectType inputObjectType = this.getInputObjectType(clazz);
        this.registerDynamicInputFields(graphQLTypeName, inputObjectType, propertyTypes);
    }

    private void registerDynamicInputFields(String graphQLTypeName, GraphQLInputObjectType graphQLInputObjectType, Collection<DefinitionType> propertyTypes) {
        ArrayList fieldDefinitions = new ArrayList();
        propertyTypes.forEach(propertyType -> {
            String propertyName = PropertyNameTranslator.translateFromUnomiToGraphQL(propertyType.getName());
            if (propertyType.hasSubTypes()) {
                String typeName = StringUtils.capitalize(propertyName) + "Input";
                if (!this.graphQLAnnotations.getContainer().getTypeRegistry().containsKey(typeName)) {
                    GraphQLInputObjectType inputType = this.createDynamicSetInputType((DefinitionType)propertyType, null, (Deque<String>)new ArrayDeque<String>());
                    if (inputType != null) {
                        fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName).type((GraphQLInputType)inputType).build());
                    }
                } else {
                    fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName).type((GraphQLInputType)this.getFromTypeRegistry(typeName)).build());
                }
            } else {
                fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().type((GraphQLInputType)UnomiToGraphQLConverter.convertPropertyType(propertyType.getTypeId())).name(propertyName).build());
            }
        });
        if (!fieldDefinitions.isEmpty()) {
            GraphQLInputObjectType transformedObjectType = graphQLInputObjectType.transform(builder -> fieldDefinitions.forEach(arg_0 -> ((GraphQLInputObjectType.Builder)builder).field(arg_0)));
            this.registerInTypeRegistry(graphQLTypeName, (GraphQLType)transformedObjectType);
        }
    }

    private void registerDynamicEventInputFields() {
        GraphQLInputObjectType.Builder builder = GraphQLInputObjectType.newInputObject().name("CDP_EventInput").fields(this.getInputObjectType(CDPEventInput.class).getFieldDefinitions());
        if (!this.additionalTypesProviders.isEmpty()) {
            this.additionalTypesProviders.forEach(provider -> {
                if (provider != null && provider.getAdditionalInputTypes() != null) {
                    provider.getAdditionalInputTypes().stream().filter(CDPEventProcessor.class::isAssignableFrom).forEach(additionalType -> {
                        String typeName = ReflectionUtil.resolveTypeName(additionalType);
                        GraphQLInputObjectType.Builder eventInput = GraphQLInputObjectType.newInputObject().name(typeName).fields(this.getInputObjectType((Class<?>)additionalType).getFieldDefinitions()).definition(InputObjectTypeDefinition.newInputObjectDefinition().additionalData("eventProcessorClass", additionalType.getName()).build());
                        builder.field(GraphQLInputObjectField.newInputObjectField().name(this.generateFieldName(typeName)).type(eventInput).build());
                    });
                }
            });
        }
        List<JSONSchema> unomiEventTypes = this.schemaService.getSchemasByTarget("events").stream().map(jsonSchemaWrapper -> GraphQLSchemaProvider.buildJSONSchema(jsonSchemaWrapper, this.schemaService)).collect(Collectors.toList());
        unomiEventTypes.forEach(eventType -> {
            String typeName = UnomiToGraphQLConverter.convertEventType(eventType.getName());
            GraphQLInputType eventInputType = (GraphQLInputType)this.getFromTypeRegistry(typeName + "Input");
            if (eventInputType == null) {
                LOGGER.warn("Couldn't find event input type {}Input, will not add it as a field.", (Object)typeName);
                return;
            }
            builder.field(GraphQLInputObjectField.newInputObjectField().name(StringUtils.decapitalize(typeName)).type(eventInputType).build());
        });
        this.registerInTypeRegistry("CDP_EventInput", (GraphQLType)builder.build());
    }

    public static JSONSchema buildJSONSchema(JsonSchemaWrapper jsonSchemaWrapper, SchemaService schemaService) {
        Map<String, Object> schemaMap;
        try {
            schemaMap = (Map<String, Object>)GraphQLObjectMapper.getInstance().readValue(jsonSchemaWrapper.getSchema(), Map.class);
        }
        catch (JsonProcessingException e) {
            LOGGER.error("Failed to process Json object", (Throwable)e);
            schemaMap = Collections.emptyMap();
        }
        return new JSONSchema(schemaMap, new JSONTypeFactory(schemaService));
    }

    private void registerDynamicEventFilterInputFields() {
        ArrayList fieldDefinitions = new ArrayList();
        List registeredFieldNames = this.getInputObjectType(CDPEventFilterInput.class).getFieldDefinitions().stream().map(GraphQLInputObjectField::getName).collect(Collectors.toList());
        if (!this.additionalTypesProviders.isEmpty()) {
            this.additionalTypesProviders.forEach(provider -> {
                if (provider != null && provider.getAdditionalInputTypes() != null) {
                    provider.getAdditionalInputTypes().stream().filter(EventFilterInputMarker.class::isAssignableFrom).forEach(additionalType -> {
                        String typeName = ReflectionUtil.resolveTypeName(additionalType);
                        String fieldName = this.generateFieldName(typeName.replace("FilterInput", ""));
                        if (!registeredFieldNames.contains(fieldName)) {
                            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().type((GraphQLInputType)this.getInputObjectType((Class<?>)additionalType)).name(fieldName).build());
                        }
                    });
                }
            });
        }
        GraphQLInputObjectType transformedObjectType = this.getInputObjectType(CDPEventFilterInput.class).transform(builder -> fieldDefinitions.forEach(arg_0 -> ((GraphQLInputObjectType.Builder)builder).field(arg_0)));
        this.registerInTypeRegistry("CDP_EventFilterInput", (GraphQLType)transformedObjectType);
    }

    private String generateFieldName(String typeName) {
        int index = typeName.indexOf("_");
        char[] chars = typeName.substring(index + 1).toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        String eventName = typeName.substring(0, index).toLowerCase() + "_" + new String(chars);
        return eventName.replace("Filter", "").replace("Input", "");
    }

    private void registerInTypeRegistry(String name, GraphQLType type) {
        this.graphQLAnnotations.getContainer().getTypeRegistry().put(name, type);
    }

    private GraphQLType getFromTypeRegistry(String name) {
        return (GraphQLType)this.graphQLAnnotations.getContainer().getTypeRegistry().get(name);
    }

    private void configureElementsContainer() {
        ProcessingElementsContainer container = this.graphQLAnnotations.getContainer();
        container.setInputPrefix("");
        container.setInputSuffix("");
    }

    private void registerExtensions() {
        if (this.extensionsProviders != null && !this.extensionsProviders.isEmpty()) {
            for (GraphQLExtensionsProvider extensionsProvider : this.extensionsProviders) {
                if (extensionsProvider.getExtensions() == null) continue;
                extensionsProvider.getExtensions().forEach(arg_0 -> ((GraphQLAnnotations)this.graphQLAnnotations).registerTypeExtension(arg_0));
            }
        }
    }

    private void transformQuery() {
        Map typeRegistry = this.graphQLAnnotations.getContainer().getTypeRegistry();
        if (this.queryProviders != null && !this.queryProviders.isEmpty()) {
            for (GraphQLQueryProvider queryProvider : this.queryProviders) {
                Set<GraphQLFieldDefinition> queries = queryProvider.getQueries(this.graphQLAnnotations);
                if (queries == null) continue;
                GraphQLObjectType transformedType = this.graphQLAnnotations.object(RootQuery.class).transform(builder -> queries.forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0)));
                typeRegistry.put("Query", transformedType);
            }
        }
    }

    private void transformMutations() {
        Map typeRegistry = this.graphQLAnnotations.getContainer().getTypeRegistry();
        if (this.mutationProviders != null && !this.mutationProviders.isEmpty()) {
            for (GraphQLMutationProvider mutationProvider : this.mutationProviders) {
                Set<GraphQLFieldDefinition> mutations = mutationProvider.getMutations(this.graphQLAnnotations);
                if (mutations == null) continue;
                GraphQLObjectType transformedMutationType = this.graphQLAnnotations.object(RootMutation.class).transform(builder -> mutations.forEach(arg_0 -> ((GraphQLObjectType.Builder)builder).field(arg_0)));
                typeRegistry.put("Mutation", transformedMutationType);
            }
        }
    }

    private void registerAdditionalTypes() {
        if (this.additionalTypesProviders == null || this.additionalTypesProviders.isEmpty()) {
            return;
        }
        for (GraphQLAdditionalTypesProvider typesProvider : this.additionalTypesProviders) {
            if (typesProvider.getAdditionalOutputTypes() == null) continue;
            this.additionalTypes.addAll(typesProvider.getAdditionalOutputTypes());
        }
    }

    private void configureCodeRegister() {
        if (this.codeRegistryProvider != null) {
            this.graphQLAnnotations.getContainer().setCodeRegistryBuilder(this.codeRegistryProvider.getCodeRegistry(this.graphQLAnnotations.getContainer().getCodeRegistryBuilder().build()));
        }
    }

    private void configureFieldVisibility() {
        if (this.fieldVisibilityProviders == null || this.fieldVisibilityProviders.isEmpty()) {
            return;
        }
        CompositeGraphQLFieldVisibility compositeVisibility = new CompositeGraphQLFieldVisibility(this.fieldVisibilityProviders);
        this.graphQLAnnotations.getContainer().getCodeRegistryBuilder().fieldVisibility((GraphqlFieldVisibility)compositeVisibility);
    }

    public GraphQLInputObjectType getInputObjectType(Class<?> annotatedClass) {
        return (GraphQLInputObjectType)this.graphQLAnnotations.getObjectHandler().getTypeRetriever().getGraphQLType(annotatedClass, this.graphQLAnnotations.getContainer(), true);
    }

    public GraphQLType getOutputType(Class<?> annotatedClass) {
        return this.graphQLAnnotations.getObjectHandler().getTypeRetriever().getGraphQLType(annotatedClass, this.graphQLAnnotations.getContainer(), false);
    }

    public static Builder create(ProfileService profileService, SchemaService schemaService) {
        return new Builder(profileService, schemaService);
    }

    static class Builder {
        final ProfileService profileService;
        final SchemaService schemaService;
        List<GraphQLTypeFunctionProvider> typeFunctionProviders;
        List<GraphQLExtensionsProvider> extensionsProviders;
        List<GraphQLAdditionalTypesProvider> additionalTypesProviders;
        List<GraphQLQueryProvider> queryProviders;
        List<GraphQLMutationProvider> mutationProviders;
        List<GraphQLSubscriptionProvider> subscriptionProviders;
        List<GraphQLFieldVisibilityProvider> fieldVisibilityProviders;
        GraphQLCodeRegistryProvider codeRegistryProvider;
        UnomiEventPublisher eventPublisher;

        private Builder(ProfileService profileService, SchemaService schemaService) {
            this.profileService = profileService;
            this.schemaService = schemaService;
        }

        public Builder typeFunctionProviders(List<GraphQLTypeFunctionProvider> typeFunctionProviders) {
            this.typeFunctionProviders = typeFunctionProviders;
            return this;
        }

        public Builder extensionsProviders(List<GraphQLExtensionsProvider> extensionsProviders) {
            this.extensionsProviders = extensionsProviders;
            return this;
        }

        public Builder additionalTypesProviders(List<GraphQLAdditionalTypesProvider> additionalTypesProviders) {
            this.additionalTypesProviders = additionalTypesProviders;
            return this;
        }

        public Builder queryProviders(List<GraphQLQueryProvider> queryProviders) {
            this.queryProviders = queryProviders;
            return this;
        }

        public Builder mutationProviders(List<GraphQLMutationProvider> mutationProviders) {
            this.mutationProviders = mutationProviders;
            return this;
        }

        public Builder subscriptionProviders(List<GraphQLSubscriptionProvider> subscriptionProviders) {
            this.subscriptionProviders = subscriptionProviders;
            return this;
        }

        public Builder codeRegistryProvider(GraphQLCodeRegistryProvider codeRegistryProvider) {
            this.codeRegistryProvider = codeRegistryProvider;
            return this;
        }

        public Builder eventPublisher(UnomiEventPublisher eventPublisher) {
            this.eventPublisher = eventPublisher;
            return this;
        }

        public Builder fieldVisibilityProviders(List<GraphQLFieldVisibilityProvider> fieldVisibilityProviders) {
            this.fieldVisibilityProviders = fieldVisibilityProviders;
            return this;
        }

        void validate() {
            Objects.requireNonNull(this.profileService, "Profile service can not be null");
        }

        public GraphQLSchemaProvider build() {
            this.validate();
            return new GraphQLSchemaProvider(this);
        }
    }

    public class JSONTypeDefinitionType
    implements DefinitionType {
        private List<JSONType> jsonTypes;
        private JSONType firstNonNullType;
        private String name;

        public JSONTypeDefinitionType(String name, List<JSONType> jsonTypes) {
            this.name = name;
            this.jsonTypes = jsonTypes;
            Optional<JSONType> firstNonNullType = jsonTypes.stream().filter(jsonType -> !"null".equals(jsonType.getType())).findFirst();
            if (firstNonNullType.isPresent()) {
                this.firstNonNullType = firstNonNullType.get();
            } else {
                LOGGER.warn("Couldn't find non null type for {} and types {}", (Object)name, jsonTypes);
            }
        }

        @Override
        public String getTypeId() {
            if (this.firstNonNullType == null) {
                return null;
            }
            return this.firstNonNullType.getType();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public boolean hasSubTypes() {
            return this.firstNonNullType instanceof JSONObjectType && ((JSONObjectType)this.firstNonNullType).getProperties() != null;
        }

        @Override
        public List<DefinitionType> getSubTypes() {
            if (!this.hasSubTypes()) {
                return new ArrayList<DefinitionType>();
            }
            return ((JSONObjectType)this.firstNonNullType).getProperties().entrySet().stream().map(entry -> new JSONTypeDefinitionType((String)entry.getKey(), (List)entry.getValue())).collect(Collectors.toList());
        }
    }

    public class PropertyTypeDefinitionType
    implements DefinitionType {
        private PropertyType propertyType;

        public PropertyTypeDefinitionType(PropertyType propertyType) {
            this.propertyType = propertyType;
        }

        @Override
        public String getTypeId() {
            return this.propertyType.getValueTypeId();
        }

        @Override
        public String getName() {
            return this.propertyType.getItemId();
        }

        @Override
        public boolean hasSubTypes() {
            return "set".equals(this.propertyType.getValueTypeId());
        }

        @Override
        public List<DefinitionType> getSubTypes() {
            return this.propertyType.getChildPropertyTypes().stream().map(x$0 -> new PropertyTypeDefinitionType((PropertyType)x$0)).collect(Collectors.toList());
        }
    }

    public static interface DefinitionType {
        public String getTypeId();

        public String getName();

        public boolean hasSubTypes();

        public List<DefinitionType> getSubTypes();
    }
}

