/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema;

import graphql.GraphQL;
import graphql.execution.ExecutionStrategy;
import graphql.execution.SubscriptionExecutionStrategy;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLSchema;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.unomi.api.services.ProfileService;
import org.apache.unomi.graphql.fetchers.event.UnomiEventPublisher;
import org.apache.unomi.graphql.providers.GraphQLAdditionalTypesProvider;
import org.apache.unomi.graphql.providers.GraphQLCodeRegistryProvider;
import org.apache.unomi.graphql.providers.GraphQLExtensionsProvider;
import org.apache.unomi.graphql.providers.GraphQLFieldVisibilityProvider;
import org.apache.unomi.graphql.providers.GraphQLMutationProvider;
import org.apache.unomi.graphql.providers.GraphQLProvider;
import org.apache.unomi.graphql.providers.GraphQLQueryProvider;
import org.apache.unomi.graphql.providers.GraphQLSubscriptionProvider;
import org.apache.unomi.graphql.providers.GraphQLTypeFunctionProvider;
import org.apache.unomi.graphql.schema.CDPEventInterfaceRegister;
import org.apache.unomi.graphql.schema.CDPProfileInterfaceRegister;
import org.apache.unomi.graphql.schema.CDPPropertyInterfaceRegister;
import org.apache.unomi.graphql.schema.GraphQLSchemaProvider;
import org.apache.unomi.graphql.types.output.CDPEventInterface;
import org.apache.unomi.graphql.types.output.CDPPersona;
import org.apache.unomi.graphql.types.output.CDPProfile;
import org.apache.unomi.graphql.types.output.CDPProfileInterface;
import org.apache.unomi.graphql.types.output.CDPPropertyInterface;
import org.apache.unomi.schema.api.SchemaService;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={GraphQLSchemaUpdater.class})
public class GraphQLSchemaUpdater {
    private final List<GraphQLQueryProvider> queryProviders = new CopyOnWriteArrayList<GraphQLQueryProvider>();
    private final List<GraphQLMutationProvider> mutationProviders = new CopyOnWriteArrayList<GraphQLMutationProvider>();
    private final List<GraphQLSubscriptionProvider> subscriptionProviders = new CopyOnWriteArrayList<GraphQLSubscriptionProvider>();
    private final List<GraphQLExtensionsProvider> extensionsProviders = new CopyOnWriteArrayList<GraphQLExtensionsProvider>();
    private final List<GraphQLAdditionalTypesProvider> additionalTypesProviders = new CopyOnWriteArrayList<GraphQLAdditionalTypesProvider>();
    private final List<GraphQLTypeFunctionProvider> typeFunctionProviders = new CopyOnWriteArrayList<GraphQLTypeFunctionProvider>();
    private List<GraphQLFieldVisibilityProvider> fieldVisibilityProviders = new CopyOnWriteArrayList<GraphQLFieldVisibilityProvider>();
    private GraphQLCodeRegistryProvider codeRegistryProvider;
    private UnomiEventPublisher eventPublisher;
    private GraphQL graphQL;
    private ProfileService profileService;
    private SchemaService schemaService;
    private CDPEventInterfaceRegister eventInterfaceRegister;
    private CDPProfileInterfaceRegister profilesInterfaceRegister;
    private CDPPropertyInterfaceRegister propertyInterfaceRegister;
    private ScheduledExecutorService executorService;
    private ScheduledFuture<?> updateFuture;
    private boolean isActivated;
    private int schemaUpdateDelay;

    @Activate
    public void activate(SchemaConfig config) {
        this.isActivated = true;
        this.schemaUpdateDelay = config.schema_update_delay();
        if (config.schema_update_delay() != 0) {
            this.executorService = Executors.newSingleThreadScheduledExecutor();
        }
        this.updateSchema();
    }

    @Deactivate
    public void deactivate() {
        this.isActivated = false;
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }

    @Reference
    public void setEventPublisher(UnomiEventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @Reference
    public void setProfileService(ProfileService profileService) {
        this.profileService = profileService;
    }

    @Reference
    public void setSchemaService(SchemaService schemaService) {
        this.schemaService = schemaService;
    }

    @Reference
    public void setEventInterfaceRegister(CDPEventInterfaceRegister eventInterfaceRegister) {
        this.eventInterfaceRegister = eventInterfaceRegister;
    }

    @Reference
    public void setProfilesInterfaceRegister(CDPProfileInterfaceRegister profilesInterfaceRegister) {
        this.profilesInterfaceRegister = profilesInterfaceRegister;
    }

    @Reference
    public void setPropertiesInterfaceRegister(CDPPropertyInterfaceRegister propertyInterfaceRegister) {
        this.propertyInterfaceRegister = propertyInterfaceRegister;
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.add((GraphQLQueryProvider)provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.add((GraphQLMutationProvider)provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.subscriptionProviders.add((GraphQLSubscriptionProvider)provider);
        }
        if (provider instanceof GraphQLAdditionalTypesProvider) {
            this.additionalTypesProviders.add((GraphQLAdditionalTypesProvider)((Object)provider));
        }
        if (provider instanceof GraphQLFieldVisibilityProvider) {
            this.fieldVisibilityProviders.add((GraphQLFieldVisibilityProvider)provider);
        }
        if (provider instanceof GraphQLCodeRegistryProvider) {
            this.codeRegistryProvider = (GraphQLCodeRegistryProvider)provider;
        }
        this.updateSchema();
    }

    public void unbindProvider(GraphQLProvider provider) {
        if (provider instanceof GraphQLQueryProvider) {
            this.queryProviders.remove(provider);
        }
        if (provider instanceof GraphQLMutationProvider) {
            this.mutationProviders.remove(provider);
        }
        if (provider instanceof GraphQLSubscriptionProvider) {
            this.subscriptionProviders.remove(provider);
        }
        if (provider instanceof GraphQLAdditionalTypesProvider) {
            this.additionalTypesProviders.remove(provider);
        }
        if (provider instanceof GraphQLFieldVisibilityProvider) {
            this.fieldVisibilityProviders.remove(provider);
        }
        if (provider instanceof GraphQLCodeRegistryProvider) {
            this.codeRegistryProvider = GraphQLCodeRegistry::newCodeRegistry;
        }
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindQueryProvider(GraphQLQueryProvider provider) {
        this.queryProviders.add(provider);
        this.updateSchema();
    }

    public void unbindQueryProvider(GraphQLQueryProvider provider) {
        this.queryProviders.remove(provider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindMutationProvider(GraphQLMutationProvider provider) {
        this.mutationProviders.add(provider);
        this.updateSchema();
    }

    public void unbindMutationProvider(GraphQLMutationProvider provider) {
        this.mutationProviders.remove(provider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindSubscriptionProvider(GraphQLSubscriptionProvider provider) {
        this.subscriptionProviders.add(provider);
        this.updateSchema();
    }

    public void unbindSubscriptionProvider(GraphQLSubscriptionProvider provider) {
        this.subscriptionProviders.remove(provider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindFieldVisibilityProvider(GraphQLFieldVisibilityProvider provider) {
        this.fieldVisibilityProviders.add(provider);
        this.updateSchema();
    }

    public void unbindFieldVisibilityProvider(GraphQLFieldVisibilityProvider provider) {
        this.fieldVisibilityProviders.remove(provider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindExtensionsProvider(GraphQLExtensionsProvider provider) {
        this.extensionsProviders.add(provider);
        this.updateSchema();
    }

    public void unbindExtensionsProvider(GraphQLExtensionsProvider provider) {
        this.extensionsProviders.remove(provider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindAdditionalTypes(GraphQLAdditionalTypesProvider provider) {
        this.additionalTypesProviders.add(provider);
        this.updateSchema();
    }

    public void unbindAdditionalTypes(GraphQLAdditionalTypesProvider provider) {
        this.additionalTypesProviders.remove(provider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void bindTypeFunctionProviders(GraphQLTypeFunctionProvider typeFunctionProvider) {
        this.typeFunctionProviders.add(typeFunctionProvider);
        this.updateSchema();
    }

    public void unbindTypeFunctionProviders(GraphQLTypeFunctionProvider typeFunctionProvider) {
        this.typeFunctionProviders.remove(typeFunctionProvider);
        this.updateSchema();
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void bindCodeRegistryProvider(GraphQLCodeRegistryProvider codeRegistryProvider) {
        this.codeRegistryProvider = codeRegistryProvider;
        this.updateSchema();
    }

    public void unbindCodeRegistryProvider(GraphQLCodeRegistryProvider codeRegistryProvider) {
        this.codeRegistryProvider = null;
        this.updateSchema();
    }

    public void updateSchema() {
        if (!this.isActivated) {
            return;
        }
        if (this.schemaUpdateDelay == 0) {
            this.doUpdateSchema();
        } else {
            if (this.updateFuture != null) {
                this.updateFuture.cancel(true);
            }
            this.updateFuture = this.executorService.scheduleWithFixedDelay(this::doUpdateSchema, 0L, this.schemaUpdateDelay, TimeUnit.SECONDS);
        }
    }

    private void doUpdateSchema() {
        GraphQLSchema graphQLSchema = this.createGraphQLSchema();
        this.graphQL = GraphQL.newGraphQL((GraphQLSchema)graphQLSchema).subscriptionExecutionStrategy((ExecutionStrategy)new SubscriptionExecutionStrategy()).build();
    }

    public GraphQL getGraphQL() {
        return this.graphQL;
    }

    private GraphQLSchema createGraphQLSchema() {
        GraphQLSchemaProvider schemaProvider = GraphQLSchemaProvider.create(this.profileService, this.schemaService).typeFunctionProviders(this.typeFunctionProviders).extensionsProviders(this.extensionsProviders).additionalTypesProviders(this.additionalTypesProviders).queryProviders(this.queryProviders).mutationProviders(this.mutationProviders).subscriptionProviders(this.subscriptionProviders).eventPublisher(this.eventPublisher).codeRegistryProvider(this.codeRegistryProvider).fieldVisibilityProviders(this.fieldVisibilityProviders).build();
        GraphQLSchema schema = schemaProvider.createSchema();
        this.profilesInterfaceRegister.register(CDPProfile.class);
        this.profilesInterfaceRegister.register(CDPPersona.class);
        if (schemaProvider.getAdditionalTypes() != null && !schemaProvider.getAdditionalTypes().isEmpty()) {
            schemaProvider.getAdditionalTypes().forEach(additionalType -> {
                if (CDPEventInterface.class.isAssignableFrom((Class<?>)additionalType)) {
                    this.eventInterfaceRegister.register((Class<? extends CDPEventInterface>)additionalType);
                }
                if (CDPProfileInterface.class.isAssignableFrom((Class<?>)additionalType)) {
                    this.profilesInterfaceRegister.register((Class<? extends CDPProfileInterface>)additionalType);
                }
                if (CDPPropertyInterface.class.isAssignableFrom((Class<?>)additionalType)) {
                    this.propertyInterfaceRegister.register((Class<? extends CDPPropertyInterface>)additionalType);
                }
            });
        }
        return schema;
    }

    public static @interface SchemaConfig {
        public int schema_update_delay() default 0;
    }
}

