/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.graphql.schema;

import graphql.Scalars;
import graphql.annotations.processor.GraphQLAnnotations;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.unomi.graphql.scalars.DateTimeFunction;
import org.apache.unomi.graphql.scalars.GeoPointFunction;
import org.apache.unomi.graphql.schema.GraphQLSchemaProvider;
import org.apache.unomi.graphql.schema.PropertyNameTranslator;
import org.apache.unomi.graphql.types.input.CDPGeoDistanceFilterInput;
import org.apache.unomi.graphql.utils.ReflectionUtil;
import org.apache.unomi.graphql.utils.StringUtils;

public class PropertyFilterUtils {
    public static List<GraphQLInputObjectField> buildInputPropertyFilters(Collection<GraphQLSchemaProvider.DefinitionType> propertyTypes, GraphQLAnnotations graphQLAnnotations) {
        if (propertyTypes == null || propertyTypes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<GraphQLInputObjectField> fieldDefinitions = new ArrayList<GraphQLInputObjectField>();
        propertyTypes.forEach(propertyType -> PropertyFilterUtils.addFilters(fieldDefinitions, propertyType, graphQLAnnotations));
        return fieldDefinitions;
    }

    private static void addFilters(List<GraphQLInputObjectField> fieldDefinitions, GraphQLSchemaProvider.DefinitionType propertyType, GraphQLAnnotations graphQLAnnotations) {
        String propertyName = PropertyNameTranslator.translateFromUnomiToGraphQL(propertyType.getName());
        if ("integer".equals(propertyType.getTypeId())) {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)Scalars.GraphQLInt).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lt").type((GraphQLInputType)Scalars.GraphQLInt).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lte").type((GraphQLInputType)Scalars.GraphQLInt).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gt").type((GraphQLInputType)Scalars.GraphQLInt).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gte").type((GraphQLInputType)Scalars.GraphQLInt).build());
        } else if ("long".equals(propertyType.getTypeId())) {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)Scalars.GraphQLLong).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lt").type((GraphQLInputType)Scalars.GraphQLLong).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lte").type((GraphQLInputType)Scalars.GraphQLLong).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gt").type((GraphQLInputType)Scalars.GraphQLLong).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gte").type((GraphQLInputType)Scalars.GraphQLLong).build());
        } else if ("float".equals(propertyType.getTypeId())) {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)Scalars.GraphQLFloat).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lt").type((GraphQLInputType)Scalars.GraphQLFloat).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lte").type((GraphQLInputType)Scalars.GraphQLFloat).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gt").type((GraphQLInputType)Scalars.GraphQLFloat).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gte").type((GraphQLInputType)Scalars.GraphQLFloat).build());
        } else if ("date".equals(propertyType.getTypeId())) {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)DateTimeFunction.DATE_TIME_SCALAR).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lt").type((GraphQLInputType)DateTimeFunction.DATE_TIME_SCALAR).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_lte").type((GraphQLInputType)DateTimeFunction.DATE_TIME_SCALAR).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gt").type((GraphQLInputType)DateTimeFunction.DATE_TIME_SCALAR).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_gte").type((GraphQLInputType)DateTimeFunction.DATE_TIME_SCALAR).build());
        } else if ("boolean".equals(propertyType.getTypeId())) {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)Scalars.GraphQLBoolean).build());
        } else if ("id".equals(propertyType.getTypeId())) {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)Scalars.GraphQLString).build());
        } else if ("set".equals(propertyType.getTypeId())) {
            if (propertyType.hasSubTypes()) {
                GraphQLInputObjectType inputObjectType;
                String typeName = StringUtils.capitalize(propertyName) + "FilterInput";
                if (!graphQLAnnotations.getContainer().getTypeRegistry().containsKey(typeName)) {
                    GraphQLInputObjectType.Builder dynamicTypeBuilder = GraphQLInputObjectType.newInputObject().name(typeName);
                    ArrayList setFieldDefinitions = new ArrayList();
                    propertyType.getSubTypes().forEach(childPropertyType -> PropertyFilterUtils.addFilters(setFieldDefinitions, childPropertyType, graphQLAnnotations));
                    dynamicTypeBuilder.fields(setFieldDefinitions);
                    inputObjectType = dynamicTypeBuilder.build();
                    graphQLAnnotations.getContainer().getTypeRegistry().put(typeName, inputObjectType);
                } else {
                    inputObjectType = (GraphQLInputObjectType)graphQLAnnotations.getContainer().getTypeRegistry().get(typeName);
                }
                fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName).type((GraphQLInputType)inputObjectType).build());
            }
        } else if ("geopoint".equals(propertyType.getTypeId())) {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)GeoPointFunction.GEOPOINT_SCALAR).build());
            String geoDistanceFilterTypeName = ReflectionUtil.resolveTypeName(CDPGeoDistanceFilterInput.class);
            GraphQLInputObjectType geoDistanceFilterType = (GraphQLInputObjectType)graphQLAnnotations.getContainer().getTypeRegistry().get(geoDistanceFilterTypeName);
            if (geoDistanceFilterType != null) {
                fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_distance").type((GraphQLInputType)geoDistanceFilterType).build());
            }
        } else {
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_equals").type((GraphQLInputType)Scalars.GraphQLString).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_startsWith").type((GraphQLInputType)Scalars.GraphQLString).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_endsWith").type((GraphQLInputType)Scalars.GraphQLString).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_contains").type((GraphQLInputType)Scalars.GraphQLString).build());
            fieldDefinitions.add(GraphQLInputObjectField.newInputObjectField().name(propertyName + "_regexp").type((GraphQLInputType)Scalars.GraphQLString).build());
        }
    }
}

